/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.websocket;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.WebSocketProcessor;
import org.atmosphere.websocket.WebSocketSupport;
import org.atmosphere.websocket.container.Jetty8WebSocketSupport;
import org.atmosphere.websocket.container.JettyWebSocketSupport;
import org.eclipse.jetty.websocket.WebSocket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyWebSocketHandler
implements WebSocket,
WebSocket.OnFrame,
WebSocket.OnBinaryMessage,
WebSocket.OnTextMessage,
WebSocket.OnControl {
    private static final Logger logger = LoggerFactory.getLogger(JettyWebSocketHandler.class);
    private WebSocketProcessor webSocketProcessor;
    private final HttpServletRequest request;
    private final AtmosphereServlet atmosphereServlet;
    private final String webSocketProcessorClassName;

    public JettyWebSocketHandler(HttpServletRequest request, AtmosphereServlet atmosphereServlet, String webSocketProcessorClassName) {
        this.request = new JettyRequestFix(request, request.getServletPath(), request.getContextPath(), request.getPathInfo(), request.getRequestURI());
        this.atmosphereServlet = atmosphereServlet;
        this.webSocketProcessorClassName = webSocketProcessorClassName;
    }

    public void onConnect(WebSocket.Outbound outbound) {
        logger.debug("WebSocket.onConnect (outbound)");
        try {
            this.webSocketProcessor = (WebSocketProcessor)JettyWebSocketHandler.class.getClassLoader().loadClass(this.webSocketProcessorClassName).getDeclaredConstructor(AtmosphereServlet.class, WebSocketSupport.class).newInstance(this.atmosphereServlet, new JettyWebSocketSupport(outbound));
            this.webSocketProcessor.connect(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onMessage(byte frame, String data) {
        logger.debug("WebSocket.onMessage (frame/string)");
        this.webSocketProcessor.broadcast(data);
    }

    public void onMessage(byte frame, byte[] data, int offset, int length) {
        logger.debug("WebSocket.onMessage (frame)");
        this.webSocketProcessor.broadcast(new String(data, offset, length));
    }

    public void onFragment(boolean more, byte opcode, byte[] data, int offset, int length) {
        logger.debug("WebSocket.onFragment");
        this.webSocketProcessor.broadcast(new String(data, offset, length));
    }

    public void onDisconnect() {
        logger.debug("WebSocket.onDisconnect");
        this.webSocketProcessor.close();
    }

    public void onMessage(byte[] data, int offset, int length) {
        logger.debug("WebSocket.onMessage (bytes)");
        this.webSocketProcessor.broadcast(data, offset, length);
    }

    public boolean onControl(byte controlCode, byte[] data, int offset, int length) {
        logger.debug("WebSocket.onControl.");
        this.webSocketProcessor.broadcast(data, offset, length);
        return false;
    }

    public boolean onFrame(byte flags, byte opcode, byte[] data, int offset, int length) {
        logger.debug("WebSocket.onFrame.");
        return false;
    }

    public void onHandshake(WebSocket.FrameConnection connection) {
        logger.debug("WebSocket.onHandshake");
    }

    public void onMessage(String data) {
        logger.debug("WebSocket.onMessage");
        this.webSocketProcessor.broadcast(data);
    }

    public void onOpen(WebSocket.Connection connection) {
        logger.debug("WebSocket.onOpen.");
        try {
            this.webSocketProcessor = (WebSocketProcessor)JettyWebSocketHandler.class.getClassLoader().loadClass(this.webSocketProcessorClassName).getDeclaredConstructor(AtmosphereServlet.class, WebSocketSupport.class).newInstance(this.atmosphereServlet, new Jetty8WebSocketSupport(connection));
            this.webSocketProcessor.connect(this.request);
        }
        catch (Exception e) {
            logger.warn("failed to connect to web socket", (Throwable)e);
        }
    }

    public void onClose(int closeCode, String message) {
        logger.debug("WebSocket.OnClose.");
        this.webSocketProcessor.close();
    }

    private static class JettyRequestFix
    extends HttpServletRequestWrapper {
        private final String contextPath;
        private final String servletPath;
        private final String pathInfo;
        private final String requestUri;

        public JettyRequestFix(HttpServletRequest request, String servletPath, String contextPath, String pathInfo, String requestUri) {
            super(request);
            this.servletPath = servletPath;
            this.contextPath = contextPath;
            this.pathInfo = pathInfo;
            this.requestUri = requestUri;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public String getPathInfo() {
            return this.pathInfo;
        }

        public String getRequestURI() {
            return this.requestUri;
        }
    }
}

