/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.jboss.servlet.http.HttpEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockingIOCometSupport
extends AsynchronousProcessor {
    private static final Logger logger = LoggerFactory.getLogger(BlockingIOCometSupport.class);
    protected static final String LATCH = "org.atmosphere.container.BlockingIOCometSupport.latch";
    protected final ConcurrentHashMap<Integer, CountDownLatch> latchs = new ConcurrentHashMap();

    public BlockingIOCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = null;
        try {
            action = this.suspended(req, res);
            if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                logger.debug("Suspending response: {}", (Object)res);
                this.suspend(action, req, res);
            } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                CountDownLatch latch;
                int latchId;
                logger.debug("Resuming response: {}", (Object)res);
                int n = latchId = req.getAttribute(LATCH) == null ? 0 : (Integer)req.getAttribute(LATCH);
                if (req.getSession(false) != null && req.getSession(false).getAttribute(LATCH) != null) {
                    latchId = (Integer)req.getSession(false).getAttribute(LATCH);
                }
                if ((latch = this.latchs.get(latchId)) == null && req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.debug("response wasn't suspended: {}", (Object)res);
                    AtmosphereServlet.Action action2 = action;
                    return action2;
                }
                latch.countDown();
                AtmosphereServlet.Action nextAction = this.resumed(req, res);
                if (nextAction.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    logger.debug("Suspending after resuming response: {}", (Object)res);
                    this.suspend(action, req, res);
                }
            }
        }
        finally {
            HttpEvent he;
            CometEvent event = (CometEvent)req.getAttribute("CometEvent");
            if (event != null) {
                event.close();
            }
            if ((he = (HttpEvent)req.getAttribute("HttpEvent")) != null) {
                he.close();
            }
        }
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void suspend(AtmosphereServlet.Action action, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        CountDownLatch latch = new CountDownLatch(1);
        int hash = latch.hashCode();
        req.setAttribute(LATCH, (Object)hash);
        this.latchs.put(hash, latch);
        if (this.supportSession()) {
            req.getSession().setAttribute(String.valueOf(req.hashCode()), (Object)hash);
        }
        try {
            if (action.timeout != -1L) {
                latch.await(action.timeout, TimeUnit.MILLISECONDS);
            } else {
                latch.await();
            }
        }
        catch (InterruptedException ex) {
            logger.debug("", (Throwable)ex);
        }
        finally {
            this.latchs.remove(hash);
            this.timedout(req, res);
        }
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        int latchId = -1;
        if (req.getAttribute(LATCH) != null) {
            latchId = (Integer)req.getAttribute(LATCH);
        }
        CountDownLatch latch = this.latchs.remove(latchId);
        AtmosphereServlet.Action a = super.cancelled(req, res);
        latch.countDown();
        return a;
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        try {
            super.action(actionEvent);
            if (actionEvent.action().type == AtmosphereServlet.Action.TYPE.RESUME && actionEvent.isInScope()) {
                int latchId = -1;
                HttpServletRequest req = actionEvent.getRequest();
                if (req.getAttribute(LATCH) != null) {
                    latchId = (Integer)req.getAttribute(LATCH);
                }
                if (latchId == -1 && this.supportSession() && req.getSession().getAttribute(LATCH) != null) {
                    latchId = (Integer)req.getSession().getAttribute(LATCH);
                }
                String s = this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE);
                if (latchId != -1 && (s == null || s.equalsIgnoreCase("false"))) {
                    CountDownLatch latch = this.latchs.remove(latchId);
                    if (latch == null) {
                        logger.error("Unable to resume the suspended connection with latchId: {}", (Object)latchId);
                    } else {
                        latch.countDown();
                    }
                } else if (req.getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) == null) {
                    logger.error("Unable to resume the suspended connection");
                }
            }
        }
        catch (Exception ex) {
            logger.error("", (Throwable)ex);
        }
    }
}

