/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.Collection;
import java.util.logging.Level;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.DefaultBroadcaster;
import org.atmosphere.cpr.DefaultBroadcasterFactory;
import org.atmosphere.util.LoggerUtils;

public abstract class BroadcasterFactory {
    protected static BroadcasterFactory factory;

    public abstract Broadcaster get() throws IllegalAccessException, InstantiationException;

    public abstract Broadcaster get(Class<? extends Broadcaster> var1, Object var2) throws IllegalAccessException, InstantiationException;

    public abstract void destroy();

    public abstract boolean add(Broadcaster var1, Object var2);

    public abstract boolean remove(Broadcaster var1, Object var2);

    public abstract Broadcaster lookup(Class<? extends Broadcaster> var1, Object var2);

    public abstract Broadcaster lookup(Class<? extends Broadcaster> var1, Object var2, boolean var3);

    public abstract Collection<Broadcaster> lookupAll();

    public static synchronized BroadcasterFactory getDefault() {
        if (factory == null) {
            Class<?> b = null;
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                b = cl.loadClass(AtmosphereServlet.getDefaultBroadcasterClassName());
            }
            catch (ClassNotFoundException e) {
                LoggerUtils.getLogger().log(Level.SEVERE, "", e);
            }
            factory = new DefaultBroadcasterFactory(b == null ? DefaultBroadcaster.class : b, AtmosphereServlet.getBroadcasterConfig());
        }
        return factory;
    }
}

