/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.BroadcasterCache;
import org.atmosphere.util.LoggerUtils;

public abstract class BroadcasterCacheBase
implements BroadcasterCache<HttpServletRequest, HttpServletResponse> {
    protected static final Logger logger = LoggerUtils.getLogger();
    protected final List<CachedMessage> queue = new CopyOnWriteArrayList<CachedMessage>();
    protected final ScheduledExecutorService reaper = Executors.newSingleThreadScheduledExecutor();
    protected int maxCachedinMs = 300000;

    @Override
    public final void start() {
        this.reaper.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                for (CachedMessage e : BroadcasterCacheBase.this.queue) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Message: " + e.message());
                    }
                    if (System.currentTimeMillis() - e.currentTime() <= (long)BroadcasterCacheBase.this.maxCachedinMs) break;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Pruning: " + e.message());
                    }
                    BroadcasterCacheBase.this.queue.remove(e);
                }
            }
        }, 0L, 60L, TimeUnit.SECONDS);
    }

    @Override
    public final void stop() {
        this.reaper.shutdown();
    }

    @Override
    public final void addToCache(AtmosphereResource<HttpServletRequest, HttpServletResponse> r, Object e) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Adding message for " + r + ": " + e);
        }
        CachedMessage cm = new CachedMessage(e, System.currentTimeMillis(), null);
        CachedMessage prev = null;
        if (!this.queue.isEmpty()) {
            prev = this.queue.get(this.queue.size() - 1);
        }
        if (prev != null) {
            prev.next(cm);
        }
        if (!this.queue.contains(cm)) {
            this.queue.add(cm);
        }
        if (prev == null) {
            cm = new CachedMessage(true);
        }
        if (r != null) {
            this.cache(r, cm);
        }
    }

    public abstract void cache(AtmosphereResource<HttpServletRequest, HttpServletResponse> var1, CachedMessage var2);

    public abstract CachedMessage retrieveLastMessage(AtmosphereResource<HttpServletRequest, HttpServletResponse> var1);

    @Override
    public final List<Object> retrieveFromCache(AtmosphereResource<HttpServletRequest, HttpServletResponse> r) {
        CachedMessage cm = this.retrieveLastMessage(r);
        boolean isNew = false;
        if (cm == null && r.getRequest().getAttribute(AtmosphereResourceImpl.PRE_SUSPEND) != null) {
            isNew = true;
        }
        boolean isHead = false;
        if (cm != null && cm.isTail) {
            cm = null;
        }
        if (cm != null) {
            if (!this.queue.contains(cm) && !this.queue.isEmpty()) {
                cm = this.queue.get(0);
                isHead = true;
            }
        } else if (isNew && !this.queue.isEmpty()) {
            cm = this.queue.get(0);
            isHead = true;
        }
        ArrayList<Object> l = new ArrayList<Object>();
        if (cm == null) {
            return l;
        }
        if (!isHead) {
            cm = cm.next();
        }
        CachedMessage prev = cm;
        while (cm != null) {
            l.add(cm.message());
            prev = cm;
            cm = cm.next();
        }
        if (prev != null) {
            this.cache(r, prev);
        }
        return l;
    }

    public int getMaxCachedinMs() {
        return this.maxCachedinMs;
    }

    public void setMaxCachedinMs(int maxCachedinMs) {
        this.maxCachedinMs = maxCachedinMs;
    }

    protected static class CachedMessage
    implements Serializable {
        public final Object message;
        public final long currentTime;
        public CachedMessage next;
        public final boolean isTail;

        public CachedMessage(boolean isTail) {
            this.currentTime = 0L;
            this.message = null;
            this.next = null;
            this.isTail = isTail;
        }

        public CachedMessage(Object message, long currentTime, CachedMessage next) {
            this.currentTime = currentTime;
            this.message = message;
            this.next = next;
            this.isTail = false;
        }

        public Object message() {
            return this.message;
        }

        public long currentTime() {
            return this.currentTime;
        }

        public CachedMessage next() {
            return this.next;
        }

        public CachedMessage next(CachedMessage next) {
            this.next = next;
            return next;
        }

        public String toString() {
            if (this.message != null) {
                return this.message.toString();
            }
            return "";
        }

        public boolean isTail() {
            return this.isTail;
        }
    }
}

