/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.CometEvent;
import org.atmosphere.cpr.AsynchronousProcessor;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;

public class TomcatCometSupport
extends AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    public static final String COMET_EVENT = "CometEvent";
    private static final IllegalStateException unableToDetectComet = new IllegalStateException(TomcatCometSupport.unableToDetectComet());
    private final ConcurrentLinkedQueue<CometEvent> resumed = new ConcurrentLinkedQueue();

    public TomcatCometSupport(AtmosphereServlet.AtmosphereConfig config) {
        super(config);
    }

    @Override
    public AtmosphereServlet.Action service(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action;
        block30: {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                throw unableToDetectComet;
            }
            action = null;
            if (event.getEventType() == CometEvent.EventType.BEGIN) {
                action = this.suspended(req, res);
                if (action.type == AtmosphereServlet.Action.TYPE.SUSPEND) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Suspending " + res);
                    }
                    try {
                        if (action.timeout != -1L) {
                            event.setTimeout((int)action.timeout);
                            break block30;
                        }
                        event.setTimeout(Integer.MAX_VALUE);
                    }
                    catch (UnsupportedOperationException ex) {}
                } else if (action.type == AtmosphereServlet.Action.TYPE.RESUME) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Resuming " + res);
                    }
                    event.close();
                } else {
                    event.close();
                }
            } else if (event.getEventType() != CometEvent.EventType.READ) {
                if (event.getEventSubType() == CometEvent.EventSubType.CLIENT_DISCONNECT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Client closed connection " + res);
                    }
                    if (!this.resumed.remove(event)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Client closed connection " + res);
                        }
                        action = this.cancelled(req, res);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Cancelling " + res);
                    }
                    event.close();
                } else if (event.getEventSubType() == CometEvent.EventSubType.TIMEOUT) {
                    if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Timing out " + res);
                    }
                    action = this.timedout(req, res);
                    event.close();
                } else if (event.getEventType() == CometEvent.EventType.ERROR) {
                    event.close();
                } else if (event.getEventType() == CometEvent.EventType.END) {
                    if (!this.resumed.remove(event)) {
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Client closed connection " + res);
                        }
                        action = this.cancelled(req, res);
                    } else if (this.logger.isLoggable(Level.FINE)) {
                        this.logger.fine("Cancelling " + res);
                    }
                    event.close();
                }
            }
        }
        return action;
    }

    @Override
    public void action(AtmosphereResourceImpl resource) {
        block5: {
            super.action(resource);
            if (resource.action().type == AtmosphereServlet.Action.TYPE.RESUME && resource.isInScope()) {
                try {
                    CometEvent event = (CometEvent)resource.getRequest().getAttribute(COMET_EVENT);
                    if (event == null) {
                        return;
                    }
                    this.resumed.offer(event);
                    if (this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE) == null || this.config.getInitParameter(AtmosphereServlet.RESUME_AND_KEEPALIVE).equalsIgnoreCase("false")) {
                        event.close();
                    }
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.FINE)) break block5;
                    this.logger.log(Level.FINE, "", ex);
                }
            }
        }
    }

    @Override
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereServlet.Action action = super.cancelled(req, res);
        if (req.getAttribute(MAX_INACTIVE) != null && (Long)Long.class.cast(req.getAttribute(MAX_INACTIVE)) == -1L) {
            CometEvent event = (CometEvent)req.getAttribute(COMET_EVENT);
            if (event == null) {
                return action;
            }
            this.resumed.offer(event);
            event.close();
        }
        return action;
    }

    private static String unableToDetectComet() {
        StringBuilder sb = new StringBuilder();
        sb.append("Tomcat failed to detect this is a Comet application because context.xml ");
        sb.append("is missing or the Http11NioProtocol Connector is not enabled.");
        sb.append("\nIf that's not the case, you can also remove META-INF/context.xml and WEB-INF/lib/atmosphere-compat-tomcat.jar");
        return sb.toString();
    }
}

