/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util;

import org.atmosphere.cpr.BroadcastFilter;

public class StringFilterAggregator
implements BroadcastFilter {
    private final int maxBufferedString;
    private final StringBuilder bufferedMessage = new StringBuilder();

    public StringFilterAggregator() {
        this.maxBufferedString = 256;
    }

    public StringFilterAggregator(int maxBufferedString) {
        this.maxBufferedString = maxBufferedString;
    }

    public BroadcastFilter.BroadcastAction filter(Object message) {
        if (message instanceof String) {
            this.bufferedMessage.append(message);
            if (this.bufferedMessage.length() < this.maxBufferedString) {
                return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.ABORT, message);
            }
            message = this.bufferedMessage.toString();
            this.bufferedMessage.delete(0, this.bufferedMessage.length());
            return new BroadcastFilter.BroadcastAction(BroadcastFilter.BroadcastAction.ACTION.CONTINUE, message);
        }
        return new BroadcastFilter.BroadcastAction(message);
    }
}

