/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.cpr.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtmosphereResourceImpl
implements AtmosphereResource<HttpServletRequest, HttpServletResponse> {
    private HttpServletRequest req;
    private HttpServletResponse res;
    protected AtmosphereServlet.Action action = new AtmosphereServlet.Action();
    protected Broadcaster broadcaster;
    private AtmosphereServlet.AtmosphereConfig config = null;
    protected CometSupport cometSupport;
    private Serializer serializer;
    private boolean isInScope = true;
    private AtmosphereResourceEventImpl event;

    public AtmosphereResourceImpl(AtmosphereServlet.AtmosphereConfig config, Broadcaster broadcaster, HttpServletRequest req, HttpServletResponse res, CometSupport cometSupport, AtmosphereResourceEventImpl event) {
        this.req = req;
        this.res = res;
        this.broadcaster = broadcaster;
        this.config = config;
        this.cometSupport = cometSupport;
        this.event = event;
        event.setResource(this);
    }

    public AtmosphereResourceEventImpl event() {
        return this.event;
    }

    @Override
    public void resume() {
        if (this.event.isSuspended()) {
            this.action.type = AtmosphereServlet.Action.TYPE.RESUME;
            this.broadcaster.removeAtmosphereResource(this);
            this.cometSupport.action(this);
        }
    }

    @Override
    public void suspend() {
        this.suspend(-1L);
    }

    @Override
    public void suspend(long timeout) {
        if (!this.event.isResumedOnTimeout()) {
            this.action.type = AtmosphereServlet.Action.TYPE.SUSPEND;
            this.action.timeout = timeout;
            this.broadcaster.addAtmosphereResource(this);
        }
    }

    @Override
    public HttpServletRequest getRequest() {
        if (!this.isInScope) {
            throw new IllegalStateException("Request object no longer valid. This object has been cancelled");
        }
        return this.req;
    }

    @Override
    public HttpServletResponse getResponse() {
        if (!this.isInScope) {
            throw new IllegalStateException("Response object no longer valid. This object has been cancelled");
        }
        return this.res;
    }

    @Override
    public Broadcaster getBroadcaster() {
        return this.broadcaster;
    }

    @Override
    public void setBroadcaster(Broadcaster broadcaster) {
        this.broadcaster = broadcaster;
    }

    protected void reset(HttpServletRequest req, HttpServletResponse res) {
        this.action.timeout = -1L;
        this.action.type = AtmosphereServlet.Action.TYPE.NONE;
        this.req = req;
        this.res = res;
    }

    @Override
    public AtmosphereServlet.AtmosphereConfig getAtmosphereConfig() {
        return this.config;
    }

    public AtmosphereServlet.Action action() {
        return this.action;
    }

    protected void isInScope(boolean isInScope) {
        this.isInScope = isInScope;
    }

    @Override
    public void setSerializer(Serializer s) {
        this.serializer = s;
    }

    @Override
    public void write(OutputStream os, Object o) throws IOException {
        if (o == null) {
            throw new IllegalStateException("Object cannot be null");
        }
        if (this.serializer != null) {
            this.serializer.write(os, o);
        } else {
            this.res.getOutputStream().write(o.toString().getBytes());
        }
    }

    @Override
    public Serializer getSerializer() {
        return this.serializer;
    }
}

