/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.gae;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEvent;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.Broadcaster;
import org.atmosphere.cpr.BroadcasterConfig;
import org.atmosphere.cpr.BroadcasterFuture;
import org.atmosphere.util.LoggerUtils;
import org.atmosphere.util.gae.GAEBroadcasterConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GAEDefaultBroadcaster
implements Broadcaster {
    private final ConcurrentLinkedQueue<AtmosphereResource> events = new ConcurrentLinkedQueue();
    private BroadcasterConfig bc;
    private Broadcaster.SCOPE scope = Broadcaster.SCOPE.APPLICATION;
    private String name = GAEDefaultBroadcaster.class.getSimpleName();

    public GAEDefaultBroadcaster() {
        this.bc = new GAEBroadcasterConfig();
    }

    @Override
    public void destroy() {
        this.bc.destroy();
    }

    @Override
    public Iterator<AtmosphereResource> getAtmosphereResources() {
        return this.events.iterator();
    }

    @Override
    public void setScope(Broadcaster.SCOPE scope) {
        this.scope = scope;
    }

    @Override
    public Broadcaster.SCOPE getScope() {
        return this.scope;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void push(Entry msg) {
        block16: {
            AtmosphereResourceEventImpl e;
            block15: {
                e = null;
                if (msg.eventsToPush != null) break block15;
                Iterator<AtmosphereResource> i$ = this.events.iterator();
                while (i$.hasNext()) {
                    AtmosphereResource r2;
                    AtmosphereResource atmosphereResource = r2 = i$.next();
                    synchronized (atmosphereResource) {
                        if (r2 instanceof AtmosphereResourceImpl) {
                            e = ((AtmosphereResourceImpl)r2).event();
                            e.setMessage(msg.message);
                        }
                        this.broadcast(r2, e);
                    }
                }
                break block16;
            }
            if (msg.eventsToPush instanceof AtmosphereResourceEvent) {
                AtmosphereResource r;
                AtmosphereResource r2 = r = (AtmosphereResource)msg.eventsToPush;
                synchronized (r2) {
                    if (r instanceof AtmosphereResourceEventImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                }
            }
            if (!(msg.eventsToPush instanceof Set)) break block16;
            Set sub = (Set)msg.eventsToPush;
            Iterator i$ = sub.iterator();
            while (i$.hasNext()) {
                AtmosphereResource r;
                AtmosphereResource atmosphereResource = r = (AtmosphereResource)i$.next();
                synchronized (atmosphereResource) {
                    if (r instanceof AtmosphereResourceEventImpl) {
                        e = ((AtmosphereResourceImpl)r).event();
                        e.setMessage(msg.message);
                    }
                    this.broadcast(r, e);
                }
            }
        }
    }

    private final void broadcast(AtmosphereResource r, AtmosphereResourceEvent e) {
        try {
            r.getAtmosphereConfig().getAtmosphereHandler().onStateChange(e);
        }
        catch (IOException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
        }
        catch (IllegalStateException ex) {
            LoggerUtils.getLogger().log(Level.WARNING, "", ex);
            this.removeAtmosphereResource(r);
        }
    }

    public BroadcasterFuture<Object> broadcast(Object msg) {
        if ((msg = this.bc.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.push(new Entry(msg, null, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, AtmosphereResource r) {
        if ((msg = (String)this.bc.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.push(new Entry(msg, r, f));
        return f;
    }

    public BroadcasterFuture<Object> broadcast(Object msg, Set<AtmosphereResource> subset) {
        if ((msg = (String)this.bc.filter(msg)) == null) {
            return null;
        }
        BroadcasterFuture<Object> f = new BroadcasterFuture<Object>(msg);
        this.push(new Entry(msg, subset, f));
        return f;
    }

    @Override
    public AtmosphereResource addAtmosphereResource(AtmosphereResource r) {
        if (this.events.contains(r)) {
            return null;
        }
        this.events.offer(r);
        r.getAtmosphereConfig().getBroadcasterLookup().add(this);
        return r;
    }

    @Override
    public AtmosphereResource removeAtmosphereResource(AtmosphereResource r) {
        if (!this.events.contains(r)) {
            return null;
        }
        this.events.remove(r);
        return r;
    }

    protected ConcurrentLinkedQueue<AtmosphereResource> atmosphereResources() {
        return this.events;
    }

    @Override
    public void setBroadcasterConfig(BroadcasterConfig bc) {
        this.bc = bc;
    }

    @Override
    public BroadcasterConfig getBroadcasterConfig() {
        return this.bc;
    }

    @Override
    public Future<Object> delayBroadcast(Object o) {
        return this.delayBroadcast(o, 0L, null);
    }

    @Override
    public Future<Object> delayBroadcast(Object o, long delay, TimeUnit t) {
        throw new IllegalStateException("ExecutorService not supported with Google App Engine");
    }

    @Override
    public Future<?> scheduleFixedBroadcast(Object o, long period, TimeUnit t) {
        throw new IllegalStateException("ExecutorService not supported with Google App Engine");
    }

    private final class Entry {
        Object message;
        Object eventsToPush;
        BroadcasterFuture f;

        Entry(Object message, Object eventsToPush, BroadcasterFuture f) {
            this.message = message;
            this.eventsToPush = eventsToPush;
            this.f = f;
        }
    }
}

