/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.atmosphere.cpr.BroadcastFilter;
import org.atmosphere.cpr.BroadcastFilterLifecycle;

public class BroadcasterConfig {
    static final int numOfProcessor = Runtime.getRuntime().availableProcessors();
    protected ConcurrentLinkedQueue<BroadcastFilter> filters = new ConcurrentLinkedQueue();
    private ExecutorService executorService;
    private ExecutorService defaultExecutorService;
    private ScheduledExecutorService scheduler;

    public BroadcasterConfig() {
        this.configExecutors();
    }

    protected void configExecutors() {
        this.defaultExecutorService = this.executorService = Executors.newFixedThreadPool(numOfProcessor);
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public boolean addFilter(BroadcastFilter e) {
        if (this.filters.contains(e)) {
            return false;
        }
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).init();
        }
        return this.filters.offer(e);
    }

    public void destroy() {
        this.getExecutorService().shutdown();
        this.getDefaultExecutorService().shutdown();
        this.getScheduledExecutorService().shutdown();
        for (BroadcastFilter f : this.filters) {
            if (!(f instanceof BroadcastFilterLifecycle)) continue;
            ((BroadcastFilterLifecycle)f).destroy();
        }
    }

    public boolean removeFilter(BroadcastFilter e) {
        if (e instanceof BroadcastFilterLifecycle) {
            ((BroadcastFilterLifecycle)e).destroy();
        }
        return this.filters.remove(e);
    }

    public Object filter(Object object) {
        Object transformed = object;
        for (BroadcastFilter mf : this.filters) {
            transformed = mf.filter(transformed);
            if (transformed != null) continue;
            return null;
        }
        return transformed;
    }

    public ExecutorService getDefaultExecutorService() {
        return this.defaultExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService executorService) {
        this.executorService = executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledExecutorService getScheduledExecutorService() {
        ExecutorService executorService = this.defaultExecutorService;
        synchronized (executorService) {
            if (this.scheduler == null) {
                this.scheduler = Executors.newScheduledThreadPool(numOfProcessor);
            }
        }
        return this.scheduler;
    }
}

