/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.cpr;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResourceEventImpl;
import org.atmosphere.cpr.AtmosphereResourceImpl;
import org.atmosphere.cpr.AtmosphereServlet;
import org.atmosphere.cpr.CometSupport;
import org.atmosphere.util.LoggerUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AsynchronousProcessor
implements CometSupport<AtmosphereResourceImpl> {
    private static final AtmosphereServlet.Action timedoutAction = new AtmosphereServlet.Action();
    private static final AtmosphereServlet.Action cancelledAction = new AtmosphereServlet.Action();
    protected final Logger logger = LoggerUtils.getLogger();
    protected static final String RESOURCE_EVENT = "org.atmosphere.cpr.AtmosphereResourceImpl";
    public static final String SUPPORT_SESSION = "org.atmosphere.cpr.AsynchronousProcessor.supportSession";
    private final AtmosphereServlet.AtmosphereConfig config;
    protected final ConcurrentHashMap<HttpServletRequest, AtmosphereResource> aliveRequests = new ConcurrentHashMap();

    public AsynchronousProcessor(AtmosphereServlet.AtmosphereConfig config) {
        this.config = config;
    }

    @Override
    public void init(ServletConfig sc) throws ServletException {
    }

    protected boolean supportSession() {
        return this.config.supportSession;
    }

    @Override
    public String getContainerName() {
        return this.config.getServletConfig().getServletContext().getServerInfo();
    }

    public AtmosphereServlet.Action suspended(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(suspend) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    AtmosphereServlet.Action action(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.supportSession()) {
            HttpSession session = req.getSession(true);
            session.setMaxInactiveInterval(-1);
        }
        req.setAttribute(SUPPORT_SESSION, (Object)this.supportSession());
        AtmosphereServlet.AtmosphereHandlerWrapper g = this.map(req.getServletPath());
        AtmosphereResourceEventImpl e = new AtmosphereResourceEventImpl();
        AtmosphereResourceImpl re = new AtmosphereResourceImpl(this.config, g.broadcaster, req, res, this, e);
        g.atmosphereHandler.onRequest(re);
        if (e.isSuspended()) {
            this.aliveRequests.put(req, re);
        }
        return re.action();
    }

    @Override
    public void action(AtmosphereResourceImpl actionEvent) {
        this.aliveRequests.remove(actionEvent.getRequest());
    }

    AtmosphereServlet.AtmosphereHandlerWrapper map(String servletPath) throws ServletException {
        AtmosphereServlet.AtmosphereHandlerWrapper g;
        if (servletPath.equals("")) {
            servletPath = "/";
        }
        if ((g = this.config.handlers().get(servletPath)) == null) {
            servletPath = !servletPath.endsWith("/") ? servletPath + "/*" : servletPath + "*";
            g = this.config.handlers().get(servletPath);
            if (g == null && (g = this.config.handlers().get("/*")) == null) {
                this.logger.warning("No AtmosphereHandler maps request for " + servletPath);
                for (String m : this.config.handlers().keySet()) {
                    this.logger.warning("\tAtmosphereHandler detected: " + m);
                }
                throw new ServletException("No AtmosphereHandler maps request for" + servletPath);
            }
        }
        this.config.ah = g.atmosphereHandler;
        this.config.getBroadcasterLookup().add(g.broadcaster);
        return g;
    }

    public AtmosphereServlet.Action resumed(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("(resumed) invoked:\n HttpServletRequest: " + req + "\n HttpServletResponse: " + res);
        }
        return this.action(req, res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosphereServlet.Action timedout(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereResourceImpl re = null;
        try {
            if (req == null || res == null) {
                this.logger.warning("Invalid Request/Response: " + req + "/" + res);
                AtmosphereServlet.Action action = timedoutAction;
                return action;
            }
            AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req.getServletPath());
            re = (AtmosphereResourceImpl)this.aliveRequests.remove(req);
            if (re != null) {
                re.event().isResumedOnTimeout = true;
                re.getBroadcaster().removeAtmosphereResource(re);
                if (!re.getResponse().equals(res)) {
                    this.logger.warning("Invalid response: " + res);
                } else {
                    aw.atmosphereHandler.onStateChange(re.event());
                }
            }
        }
        finally {
            if (re != null) {
                re.isInScope(false);
            }
        }
        return timedoutAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtmosphereServlet.Action cancelled(HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
        AtmosphereResourceImpl re = null;
        try {
            AtmosphereServlet.AtmosphereHandlerWrapper aw = this.map(req.getServletPath());
            re = (AtmosphereResourceImpl)this.aliveRequests.remove(req);
            if (re != null) {
                re.event().setCancelled(true);
                re.getBroadcaster().removeAtmosphereResource(re);
                if (!re.getResponse().equals(res)) {
                    this.logger.warning("Invalid response: " + res);
                } else {
                    aw.atmosphereHandler.onStateChange(re.event());
                }
            }
        }
        catch (Throwable ex) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.log(Level.FINE, "", ex);
            }
        }
        finally {
            if (re != null) {
                re.isInScope(false);
            }
        }
        return cancelledAction;
    }
}

