/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.timeout;

import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.netty.timeout.ReadTimeoutTimerTask;
import org.asynchttpclient.netty.timeout.RequestTimeoutTimerTask;
import org.asynchttpclient.netty.timeout.TimeoutTimerTask;
import org.asynchttpclient.util.DateUtils;

public class TimeoutsHolder {
    private final Timeout requestTimeout;
    private final AtomicBoolean cancelled = new AtomicBoolean();
    private final Timer nettyTimer;
    private final NettyRequestSender requestSender;
    private final long requestTimeoutMillisTime;
    private final long readTimeoutValue;
    private volatile Timeout readTimeout;
    private final NettyResponseFuture<?> nettyResponseFuture;
    private volatile InetSocketAddress remoteAddress;

    public TimeoutsHolder(Timer nettyTimer, NettyResponseFuture<?> nettyResponseFuture, NettyRequestSender requestSender, AsyncHttpClientConfig config, InetSocketAddress originalRemoteAddress) {
        this.nettyTimer = nettyTimer;
        this.nettyResponseFuture = nettyResponseFuture;
        this.requestSender = requestSender;
        this.remoteAddress = originalRemoteAddress;
        Request targetRequest = nettyResponseFuture.getTargetRequest();
        long readTimeoutInMs = targetRequest.getReadTimeout().toMillis();
        this.readTimeoutValue = readTimeoutInMs == 0L ? config.getReadTimeout().toMillis() : readTimeoutInMs;
        long requestTimeoutInMs = targetRequest.getRequestTimeout().toMillis();
        if (requestTimeoutInMs == 0L) {
            requestTimeoutInMs = config.getRequestTimeout().toMillis();
        }
        if (requestTimeoutInMs > -1L) {
            this.requestTimeoutMillisTime = DateUtils.unpreciseMillisTime() + requestTimeoutInMs;
            this.requestTimeout = this.newTimeout(new RequestTimeoutTimerTask(nettyResponseFuture, requestSender, this, requestTimeoutInMs), requestTimeoutInMs);
        } else {
            this.requestTimeoutMillisTime = -1L;
            this.requestTimeout = null;
        }
    }

    public void setResolvedRemoteAddress(InetSocketAddress address) {
        this.remoteAddress = address;
    }

    InetSocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    public void startReadTimeout() {
        if (this.readTimeoutValue != -1L) {
            this.startReadTimeout(null);
        }
    }

    void startReadTimeout(ReadTimeoutTimerTask task) {
        if (this.requestTimeout == null || !this.requestTimeout.isExpired() && this.readTimeoutValue < this.requestTimeoutMillisTime - DateUtils.unpreciseMillisTime()) {
            if (task == null) {
                task = new ReadTimeoutTimerTask(this.nettyResponseFuture, this.requestSender, this, this.readTimeoutValue);
            }
            this.readTimeout = this.newTimeout(task, this.readTimeoutValue);
        } else if (task != null) {
            task.clean();
        }
    }

    public void cancel() {
        if (this.cancelled.compareAndSet(false, true)) {
            if (this.requestTimeout != null) {
                this.requestTimeout.cancel();
                ((TimeoutTimerTask)this.requestTimeout.task()).clean();
            }
            if (this.readTimeout != null) {
                this.readTimeout.cancel();
                ((TimeoutTimerTask)this.readTimeout.task()).clean();
            }
        }
    }

    private Timeout newTimeout(TimerTask task, long delay) {
        if (this.requestSender == null || this.nettyTimer == null || this.requestSender.isClosed()) {
            return null;
        }
        return this.nettyTimer.newTimeout(task, delay, TimeUnit.MILLISECONDS);
    }
}

