/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.handler.intercept;

import io.netty.channel.Channel;
import io.netty.util.concurrent.Future;
import org.asynchttpclient.Request;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.proxy.ProxyServer;
import org.asynchttpclient.proxy.ProxyType;
import org.asynchttpclient.uri.Uri;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSuccessInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectSuccessInterceptor.class);
    private final ChannelManager channelManager;
    private final NettyRequestSender requestSender;

    ConnectSuccessInterceptor(ChannelManager channelManager, NettyRequestSender requestSender) {
        this.channelManager = channelManager;
        this.requestSender = requestSender;
    }

    public boolean exitAfterHandlingConnect(Channel channel, NettyResponseFuture<?> future, Request request, ProxyServer proxyServer) {
        if (future.isKeepAlive()) {
            future.attachChannel(channel, true);
        }
        Uri requestUri = request.getUri();
        LOGGER.debug("Connecting to proxy {} for scheme {}", (Object)proxyServer, (Object)requestUri.getScheme());
        Future<Channel> whenHandshaked = proxyServer != null && ProxyType.HTTPS.equals((Object)proxyServer.getProxyType()) ? this.channelManager.updatePipelineForHttpsTunneling(channel.pipeline(), requestUri, proxyServer) : this.channelManager.updatePipelineForHttpTunneling(channel.pipeline(), requestUri);
        future.setReuseChannel(true);
        future.setConnectAllowed(false);
        Request targetRequest = future.getTargetRequest().toBuilder().build();
        if (whenHandshaked == null) {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest);
        } else {
            this.requestSender.drainChannelAndExecuteNextRequest(channel, future, targetRequest, whenHandshaked);
        }
        return true;
    }
}

