/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.cookie;

import java.util.BitSet;
import java.util.Date;
import org.asynchttpclient.cookie.DateParser;
import org.asynchttpclient.util.Assertions;

public class CookieUtil {
    private static final BitSet VALID_COOKIE_NAME_OCTETS = CookieUtil.validCookieNameOctets();
    private static final BitSet VALID_COOKIE_VALUE_OCTETS = CookieUtil.validCookieValueOctets();
    private static final BitSet VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS = CookieUtil.validCookieAttributeValueOctets();

    private static BitSet validCookieNameOctets() {
        int[] separators;
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        for (int separator : separators = new int[]{40, 41, 60, 62, 64, 44, 59, 58, 92, 34, 47, 91, 93, 63, 61, 123, 125, 32, 9}) {
            bits.set(separator, false);
        }
        return bits;
    }

    private static BitSet validCookieValueOctets() {
        int i;
        BitSet bits = new BitSet();
        bits.set(33);
        for (i = 35; i <= 43; ++i) {
            bits.set(i);
        }
        for (i = 45; i <= 58; ++i) {
            bits.set(i);
        }
        for (i = 60; i <= 91; ++i) {
            bits.set(i);
        }
        for (i = 93; i <= 126; ++i) {
            bits.set(i);
        }
        return bits;
    }

    private static BitSet validCookieAttributeValueOctets() {
        BitSet bits = new BitSet();
        for (int i = 32; i < 127; ++i) {
            bits.set(i);
        }
        bits.set(59, false);
        return bits;
    }

    static String validateCookieName(String name) {
        name = Assertions.assertNotNull(name, "name").trim();
        Assertions.assertNotEmpty(name, "name");
        int i = CookieUtil.firstInvalidOctet(name, VALID_COOKIE_NAME_OCTETS);
        if (i != -1) {
            throw new IllegalArgumentException("name contains prohibited character: " + name.charAt(i));
        }
        return name;
    }

    static String validateCookieValue(String value) {
        CharSequence unwrappedValue = CookieUtil.unwrapValue(value = Assertions.assertNotNull(value, "name").trim());
        int i = CookieUtil.firstInvalidOctet(unwrappedValue, VALID_COOKIE_VALUE_OCTETS);
        if (i != -1) {
            throw new IllegalArgumentException("value contains prohibited character: " + unwrappedValue.charAt(i));
        }
        return value;
    }

    static String validateCookieAttribute(String name, String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        int i = CookieUtil.firstInvalidOctet(value, VALID_COOKIE_ATTRIBUTE_VALUE_OCTETS);
        if (i != -1) {
            throw new IllegalArgumentException(name + " contains prohibited character: " + value.charAt(i));
        }
        return value;
    }

    static int firstInvalidCookieValueOctet(CharSequence cs) {
        return CookieUtil.firstInvalidOctet(cs, VALID_COOKIE_VALUE_OCTETS);
    }

    static int firstInvalidOctet(CharSequence cs, BitSet bits) {
        for (int i = 0; i < cs.length(); ++i) {
            char c = cs.charAt(i);
            if (bits.get(c)) continue;
            return i;
        }
        return -1;
    }

    static CharSequence unwrapValue(CharSequence cs) {
        int len = cs.length();
        if (len > 0 && cs.charAt(0) == '\"') {
            if (len >= 2 && cs.charAt(len - 1) == '\"') {
                return len == 2 ? "" : cs.subSequence(1, len - 1);
            }
            return null;
        }
        return cs;
    }

    static long computeExpires(String expires) {
        Date expiresDate;
        if (expires != null && (expiresDate = DateParser.parse(expires)) != null) {
            return expiresDate.getTime();
        }
        return Long.MIN_VALUE;
    }

    private CookieUtil() {
    }
}

