/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.util;

import java.nio.charset.CharacterCodingException;

public abstract class Utf8Decoder {
    private static final byte[] TYPES = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 10, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 3, 3, 11, 6, 6, 6, 5, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private static final byte[] STATES = new byte[]{0, 12, 24, 36, 60, 96, 84, 12, 12, 12, 48, 72, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 0, 12, 12, 12, 12, 12, 0, 12, 0, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 24, 12, 12, 12, 12, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 36, 12, 36, 12, 12, 12, 36, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};
    protected static final int UTF8_ACCEPT = 0;
    protected static final int UTF8_REJECT = 12;
    protected StringBuilder sb = new StringBuilder();
    protected int state = 0;
    private int codePoint = 0;

    protected void write(byte b) throws CharacterCodingException {
        byte t = TYPES[b & 0xFF];
        this.codePoint = this.state != 0 ? b & 0x3F | this.codePoint << 6 : 255 >> t & b;
        this.state = STATES[this.state + t];
        if (this.state == 0) {
            if (this.codePoint < 55296) {
                this.sb.append((char)this.codePoint);
            } else {
                this.appendCodePointChars();
            }
        } else if (this.state == 12) {
            throw new CharacterCodingException();
        }
    }

    private void appendCodePointChars() {
        if (Character.isBmpCodePoint(this.codePoint)) {
            this.sb.append((char)this.codePoint);
        } else if (Character.isValidCodePoint(this.codePoint)) {
            char charIndexPlus1 = Character.lowSurrogate(this.codePoint);
            char charIndex = Character.highSurrogate(this.codePoint);
            this.sb.append(charIndex).append(charIndexPlus1);
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void reset() {
        this.sb.setLength(0);
        this.state = 0;
        this.codePoint = 0;
    }
}

