/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.request.body.generator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.asynchttpclient.request.body.Body;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.FeedableBodyGenerator;

public final class SimpleFeedableBodyGenerator
implements FeedableBodyGenerator,
BodyGenerator {
    private static final byte[] END_PADDING = "\r\n".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] ZERO = "0".getBytes(StandardCharsets.US_ASCII);
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private final Queue<BodyPart> queue = new ConcurrentLinkedQueue<BodyPart>();
    private FeedableBodyGenerator.FeedListener listener;
    private boolean writeChunkBoundaries = false;

    @Override
    public Body createBody() {
        return new PushBody();
    }

    @Override
    public void feed(ByteBuffer buffer, boolean isLast) {
        this.queue.offer(new BodyPart(buffer, isLast));
        if (this.listener != null) {
            this.listener.onContentAdded();
        }
    }

    @Override
    public void setListener(FeedableBodyGenerator.FeedListener listener) {
        this.listener = listener;
    }

    @Override
    public void writeChunkBoundaries() {
        this.writeChunkBoundaries = true;
    }

    private void move(ByteBuffer destination, ByteBuffer source) {
        int size = Math.min(destination.remaining(), source.remaining());
        if (size > 0) {
            ByteBuffer slice = source.slice();
            slice.limit(size);
            destination.put(slice);
            source.position(source.position() + size);
        }
    }

    private final class BodyPart {
        private final boolean isLast;
        private ByteBuffer size = null;
        private final ByteBuffer buffer;
        private ByteBuffer endPadding = null;

        public BodyPart(ByteBuffer buffer, boolean isLast) {
            this.buffer = buffer;
            this.isLast = isLast;
        }

        private void initBoundaries() {
            if (this.size == null && this.endPadding == null) {
                if (SimpleFeedableBodyGenerator.this.writeChunkBoundaries) {
                    if (this.buffer.hasRemaining()) {
                        byte[] sizeAsHex = Integer.toHexString(this.buffer.remaining()).getBytes(StandardCharsets.US_ASCII);
                        this.size = ByteBuffer.allocate(sizeAsHex.length + END_PADDING.length);
                        this.size.put(sizeAsHex);
                        this.size.put(END_PADDING);
                        this.size.flip();
                    } else {
                        this.size = EMPTY_BUFFER;
                    }
                    if (this.isLast) {
                        this.endPadding = ByteBuffer.allocate(END_PADDING.length * 3 + ZERO.length);
                        if (this.buffer.hasRemaining()) {
                            this.endPadding.put(END_PADDING);
                        }
                        this.endPadding.put(ZERO);
                        this.endPadding.put(END_PADDING);
                        this.endPadding.put(END_PADDING);
                        this.endPadding.flip();
                    } else {
                        this.endPadding = ByteBuffer.wrap(END_PADDING);
                    }
                } else {
                    this.size = EMPTY_BUFFER;
                    this.endPadding = EMPTY_BUFFER;
                }
            }
        }
    }

    public final class PushBody
    implements Body {
        private Body.State state = Body.State.Continue;

        @Override
        public long getContentLength() {
            return -1L;
        }

        @Override
        public Body.State read(ByteBuffer buffer) throws IOException {
            switch (this.state) {
                case Continue: {
                    return this.readNextPart(buffer);
                }
                case Stop: {
                    return Body.State.Stop;
                }
            }
            throw new IllegalStateException("Illegal process state.");
        }

        private Body.State readNextPart(ByteBuffer buffer) throws IOException {
            Body.State res = Body.State.Suspend;
            while (buffer.hasRemaining() && this.state != Body.State.Stop) {
                BodyPart nextPart = (BodyPart)SimpleFeedableBodyGenerator.this.queue.peek();
                if (nextPart == null) {
                    return res;
                }
                if (!nextPart.buffer.hasRemaining() && !nextPart.isLast) {
                    SimpleFeedableBodyGenerator.this.queue.remove();
                    continue;
                }
                res = Body.State.Continue;
                this.readBodyPart(buffer, nextPart);
            }
            return res;
        }

        private void readBodyPart(ByteBuffer buffer, BodyPart part) {
            part.initBoundaries();
            SimpleFeedableBodyGenerator.this.move(buffer, part.size);
            SimpleFeedableBodyGenerator.this.move(buffer, part.buffer);
            SimpleFeedableBodyGenerator.this.move(buffer, part.endPadding);
            if (!part.buffer.hasRemaining() && !part.endPadding.hasRemaining()) {
                if (part.isLast) {
                    this.state = Body.State.Stop;
                }
                SimpleFeedableBodyGenerator.this.queue.remove();
            }
        }

        @Override
        public void close() {
        }
    }
}

