/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.request.body;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.request.ProgressListener;
import org.asynchttpclient.netty.request.body.NettyBody;
import org.asynchttpclient.util.MiscUtils;

public class NettyFileBody
implements NettyBody {
    private final File file;
    private final long offset;
    private final long length;
    private final AsyncHttpClientConfig config;

    public NettyFileBody(File file, AsyncHttpClientConfig config) {
        this(file, 0L, file.length(), config);
    }

    public NettyFileBody(File file, long offset, long length, AsyncHttpClientConfig config) {
        if (!file.isFile()) {
            throw new IllegalArgumentException(String.format("File %s is not a file or doesn't exist", file.getAbsolutePath()));
        }
        this.file = file;
        this.offset = offset;
        this.length = length;
        this.config = config;
    }

    public File getFile() {
        return this.file;
    }

    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getContentLength() {
        return this.length;
    }

    @Override
    public String getContentType() {
        return null;
    }

    @Override
    public void write(Channel channel, NettyResponseFuture<?> future) throws IOException {
        final RandomAccessFile raf = new RandomAccessFile(this.file, "r");
        try {
            ChannelFuture writeFuture;
            if (ChannelManager.isSslHandlerConfigured(channel.pipeline()) || this.config.isDisableZeroCopy()) {
                writeFuture = channel.write((Object)new ChunkedFile(raf, this.offset, this.length, this.config.getChunkedFileChunkSize()), (ChannelPromise)channel.newProgressivePromise());
            } else {
                DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), this.offset, this.length);
                writeFuture = channel.write((Object)region, (ChannelPromise)channel.newProgressivePromise());
            }
            writeFuture.addListener((GenericFutureListener)new ProgressListener(future.getAsyncHandler(), future, false, this.getContentLength()){

                @Override
                public void operationComplete(ChannelProgressiveFuture cf) {
                    MiscUtils.closeSilently(raf);
                    super.operationComplete(cf);
                }
            });
            channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        catch (IOException ex) {
            MiscUtils.closeSilently(raf);
            throw ex;
        }
    }
}

