/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient;

import io.netty.handler.codec.http.HttpHeaders;
import java.net.SocketAddress;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Response;
import org.asynchttpclient.cookie.Cookie;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.asynchttpclient.util.MiscUtils;

public abstract class ResponseBase
implements Response {
    protected final List<HttpResponseBodyPart> bodyParts;
    protected final HttpResponseHeaders headers;
    protected final HttpResponseStatus status;
    private List<Cookie> cookies;

    protected ResponseBase(HttpResponseStatus status, HttpResponseHeaders headers, List<HttpResponseBodyPart> bodyParts) {
        this.bodyParts = bodyParts;
        this.headers = headers;
        this.status = status;
    }

    protected abstract List<Cookie> buildCookies();

    protected Charset calculateCharset(Charset charset) {
        String contentType;
        if (charset == null && (contentType = this.getContentType()) != null) {
            charset = HttpUtils.parseCharset(contentType);
        }
        return charset != null ? charset : HttpUtils.DEFAULT_CHARSET;
    }

    @Override
    public final int getStatusCode() {
        return this.status.getStatusCode();
    }

    @Override
    public final String getStatusText() {
        return this.status.getStatusText();
    }

    @Override
    public final Uri getUri() {
        return this.status.getUri();
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.status.getRemoteAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.status.getLocalAddress();
    }

    @Override
    public final String getContentType() {
        return this.headers != null ? this.getHeader("Content-Type") : null;
    }

    @Override
    public final String getHeader(String name) {
        return this.headers != null ? this.getHeaders().get(name) : null;
    }

    @Override
    public final List<String> getHeaders(String name) {
        return this.headers != null ? this.getHeaders().getAll(name) : Collections.emptyList();
    }

    @Override
    public final HttpHeaders getHeaders() {
        return this.headers != null ? this.headers.getHeaders() : HttpHeaders.EMPTY_HEADERS;
    }

    @Override
    public final boolean isRedirected() {
        switch (this.status.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Cookie> getCookies() {
        if (this.headers == null) {
            return Collections.emptyList();
        }
        if (this.cookies == null) {
            this.cookies = this.buildCookies();
        }
        return this.cookies;
    }

    @Override
    public boolean hasResponseStatus() {
        return this.status != null;
    }

    @Override
    public boolean hasResponseHeaders() {
        return this.headers != null && !this.headers.getHeaders().isEmpty();
    }

    @Override
    public boolean hasResponseBody() {
        return MiscUtils.isNonEmpty(this.bodyParts);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append(" {\n").append("\tstatusCode=").append(this.getStatusCode()).append("\n").append("\theaders=\n");
        for (Map.Entry header : this.getHeaders()) {
            sb.append("\t\t").append((String)header.getKey()).append(": ").append((String)header.getValue()).append("\n");
        }
        sb.append("\tbody=\n").append(this.getResponseBody()).append("\n").append("}").toString();
        return sb.toString();
    }
}

