/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.netty.channel;

import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.ConnectException;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.AsyncHandlerExtensions;
import org.asynchttpclient.handler.AsyncHandlerExtensionsUtils;
import org.asynchttpclient.netty.NettyResponseFuture;
import org.asynchttpclient.netty.SimpleChannelFutureListener;
import org.asynchttpclient.netty.SimpleFutureListener;
import org.asynchttpclient.netty.channel.ChannelManager;
import org.asynchttpclient.netty.channel.ChannelState;
import org.asynchttpclient.netty.channel.Channels;
import org.asynchttpclient.netty.future.StackTraceInspector;
import org.asynchttpclient.netty.request.NettyRequestSender;
import org.asynchttpclient.uri.Uri;
import org.asynchttpclient.util.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NettyConnectListener<T>
extends SimpleChannelFutureListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyConnectListener.class);
    private final NettyRequestSender requestSender;
    private final NettyResponseFuture<T> future;
    private final ChannelManager channelManager;
    private final boolean channelPreempted;
    private final Object partitionKey;

    public NettyConnectListener(NettyResponseFuture<T> future, NettyRequestSender requestSender, ChannelManager channelManager, boolean channelPreempted, Object partitionKey) {
        this.future = future;
        this.requestSender = requestSender;
        this.channelManager = channelManager;
        this.channelPreempted = channelPreempted;
        this.partitionKey = partitionKey;
    }

    private void abortChannelPreemption() {
        if (this.channelPreempted) {
            this.channelManager.abortChannelPreemption(this.partitionKey);
        }
    }

    private void writeRequest(Channel channel) {
        LOGGER.debug("Using non-cached Channel {} for {} '{}'", new Object[]{channel, this.future.getNettyRequest().getHttpRequest().getMethod(), this.future.getNettyRequest().getHttpRequest().getUri()});
        Channels.setAttribute(channel, this.future);
        if (this.future.isDone()) {
            this.abortChannelPreemption();
            return;
        }
        this.channelManager.registerOpenChannel(channel, this.partitionKey);
        this.future.attachChannel(channel, false);
        this.requestSender.writeRequest(this.future, channel);
    }

    @Override
    public void onSuccess(final Channel channel) {
        Request request = this.future.getTargetRequest();
        Uri uri = request.getUri();
        if (this.future.getProxyServer() == null && uri.isSecured()) {
            SslHandler sslHandler = this.channelManager.addSslHandler(channel.pipeline(), uri, request.getVirtualHost());
            final AsyncHandlerExtensions asyncHandlerExtensions = AsyncHandlerExtensionsUtils.toAsyncHandlerExtensions(this.future.getAsyncHandler());
            if (asyncHandlerExtensions != null) {
                asyncHandlerExtensions.onTlsHandshakeAttempt();
            }
            sslHandler.handshakeFuture().addListener((GenericFutureListener)new SimpleFutureListener<Channel>(){

                @Override
                protected void onSuccess(Channel value) throws Exception {
                    if (asyncHandlerExtensions != null) {
                        asyncHandlerExtensions.onTlsHandshakeSuccess();
                    }
                    NettyConnectListener.this.writeRequest(channel);
                }

                @Override
                protected void onFailure(Throwable cause) throws Exception {
                    if (asyncHandlerExtensions != null) {
                        asyncHandlerExtensions.onTlsHandshakeFailure(cause);
                    }
                    NettyConnectListener.this.onFailure(channel, cause);
                }
            });
        } else {
            this.writeRequest(channel);
        }
    }

    @Override
    public void onFailure(Channel channel, Throwable cause) {
        this.abortChannelPreemption();
        boolean canRetry = this.future.canRetry();
        LOGGER.debug("Trying to recover from failing to connect channel {} with a retry value of {} ", (Object)channel, (Object)canRetry);
        if (canRetry && cause != null && (this.future.getChannelState() != ChannelState.NEW || StackTraceInspector.recoverOnNettyDisconnectException(cause)) && this.requestSender.retry(this.future)) {
            return;
        }
        LOGGER.debug("Failed to recover from connect exception: {} with channel {}", (Object)cause, (Object)channel);
        boolean printCause = cause != null && cause.getMessage() != null;
        String printedCause = printCause ? cause.getMessage() : HttpUtils.getBaseUrl(this.future.getUri());
        ConnectException e = new ConnectException(printedCause);
        if (cause != null) {
            e.initCause(cause);
        }
        this.future.abort(e);
    }
}

