/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava2.maybe;

import io.reactivex.MaybeEmitter;
import io.reactivex.exceptions.CompositeException;
import io.reactivex.exceptions.Exceptions;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseBodyPart;
import org.asynchttpclient.HttpResponseHeaders;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.extras.rxjava2.DisposedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMaybeAsyncHandlerBridge<T>
implements AsyncHandler<Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractMaybeAsyncHandlerBridge.class);
    private static volatile DisposedException sharedDisposed;
    protected final MaybeEmitter<T> emitter;
    private final AtomicBoolean delegateTerminated = new AtomicBoolean();

    protected AbstractMaybeAsyncHandlerBridge(MaybeEmitter<T> emitter) {
        this.emitter = Objects.requireNonNull(emitter);
    }

    public final AsyncHandler.State onBodyPartReceived(HttpResponseBodyPart content) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onBodyPartReceived(content);
    }

    public final AsyncHandler.State onStatusReceived(HttpResponseStatus status) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onStatusReceived(status);
    }

    public final AsyncHandler.State onHeadersReceived(HttpResponseHeaders headers) throws Exception {
        return this.emitter.isDisposed() ? this.disposed() : this.delegate().onHeadersReceived(headers);
    }

    public final Void onCompleted() {
        Object result;
        if (this.delegateTerminated.getAndSet(true)) {
            return null;
        }
        try {
            result = this.delegate().onCompleted();
        }
        catch (Throwable t) {
            this.emitOnError(t);
            return null;
        }
        if (!this.emitter.isDisposed()) {
            if (result == null) {
                this.emitter.onComplete();
            } else {
                this.emitter.onSuccess(result);
            }
        }
        return null;
    }

    public final void onThrowable(Throwable t) {
        if (this.delegateTerminated.getAndSet(true)) {
            return;
        }
        Throwable error = t;
        try {
            this.delegate().onThrowable(t);
        }
        catch (Throwable x) {
            error = new CompositeException(Arrays.asList(t, x));
        }
        this.emitOnError(error);
    }

    protected final AsyncHandler.State disposed() {
        if (!this.delegateTerminated.getAndSet(true)) {
            DisposedException disposed = sharedDisposed;
            if (disposed == null) {
                disposed = new DisposedException("Subscription has been disposed.");
                StackTraceElement[] stackTrace = disposed.getStackTrace();
                if (stackTrace.length > 0) {
                    disposed.setStackTrace(new StackTraceElement[]{stackTrace[0]});
                }
                sharedDisposed = disposed;
            }
            this.delegate().onThrowable((Throwable)disposed);
        }
        return AsyncHandler.State.ABORT;
    }

    protected abstract AsyncHandler<? extends T> delegate();

    private void emitOnError(Throwable error) {
        Exceptions.throwIfFatal((Throwable)error);
        if (!this.emitter.isDisposed()) {
            this.emitter.onError(error);
        } else {
            LOGGER.debug("Not propagating onError after disposal: {}", (Object)error.getMessage(), (Object)error);
        }
    }
}

