/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.rxjava.single;

import java.util.Objects;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncCompletionHandlerBase;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.extras.rxjava.single.AsyncSingleSubscriberBridge;
import org.asynchttpclient.extras.rxjava.single.ProgressAsyncSingleSubscriberBridge;
import org.asynchttpclient.handler.ProgressAsyncHandler;
import rx.Single;
import rx.SingleSubscriber;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.subscriptions.Subscriptions;

public final class AsyncHttpSingle {
    private AsyncHttpSingle() {
        throw new AssertionError((Object)"No instances for you!");
    }

    public static Single<Response> create(BoundRequestBuilder builder) {
        Objects.requireNonNull(builder);
        return AsyncHttpSingle.create(arg_0 -> ((BoundRequestBuilder)builder).execute(arg_0), AsyncCompletionHandlerBase::new);
    }

    public static Single<Response> create(Func1<? super AsyncHandler<?>, ? extends Future<?>> requestTemplate) {
        return AsyncHttpSingle.create(requestTemplate, AsyncCompletionHandlerBase::new);
    }

    public static <T> Single<T> create(BoundRequestBuilder builder, Func0<? extends AsyncHandler<? extends T>> handlerSupplier) {
        Objects.requireNonNull(builder);
        return AsyncHttpSingle.create(arg_0 -> ((BoundRequestBuilder)builder).execute(arg_0), handlerSupplier);
    }

    public static <T> Single<T> create(Func1<? super AsyncHandler<?>, ? extends Future<?>> requestTemplate, Func0<? extends AsyncHandler<? extends T>> handlerSupplier) {
        Objects.requireNonNull(requestTemplate);
        Objects.requireNonNull(handlerSupplier);
        return Single.create(subscriber -> {
            AsyncHandler<?> bridge = AsyncHttpSingle.createBridge(subscriber, (AsyncHandler)handlerSupplier.call());
            Future responseFuture = (Future)requestTemplate.call(bridge);
            subscriber.add(Subscriptions.from((Future)responseFuture));
        });
    }

    static <T> AsyncHandler<?> createBridge(SingleSubscriber<? super T> subscriber, AsyncHandler<? extends T> handler) {
        if (handler instanceof ProgressAsyncHandler) {
            return new ProgressAsyncSingleSubscriberBridge<T>(subscriber, (ProgressAsyncHandler)handler);
        }
        return new AsyncSingleSubscriberBridge<T>(subscriber, handler);
    }
}

