/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.retrofit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.Request;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.extras.retrofit.AsyncHttpClientCall;

public final class AsyncHttpClientCallFactory
implements Call.Factory {
    private final AsyncHttpClient httpClient;
    private final Supplier<AsyncHttpClient> httpClientSupplier;
    private final List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;

    public Call newCall(Request request) {
        AsyncHttpClientCall.AsyncHttpClientCallBuilder callBuilder = AsyncHttpClientCall.builder().httpClient(this.httpClient).request(request);
        AsyncHttpClientCall.runConsumers(this.callCustomizers, callBuilder);
        return callBuilder.build();
    }

    public AsyncHttpClient getHttpClient() {
        return (AsyncHttpClient)Optional.ofNullable(this.httpClientSupplier).map(Supplier::get).map(Optional::of).orElseGet(() -> Optional.ofNullable(this.httpClient)).orElseThrow(() -> new IllegalStateException("HTTP client is not set."));
    }

    AsyncHttpClientCallFactory(AsyncHttpClient httpClient, Supplier<AsyncHttpClient> httpClientSupplier, List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
        this.httpClient = httpClient;
        this.httpClientSupplier = httpClientSupplier;
        this.callCustomizers = callCustomizers;
    }

    public static AsyncHttpClientCallFactoryBuilder builder() {
        return new AsyncHttpClientCallFactoryBuilder();
    }

    public AsyncHttpClientCallFactoryBuilder toBuilder() {
        return new AsyncHttpClientCallFactoryBuilder().httpClient(this.httpClient).httpClientSupplier(this.httpClientSupplier).callCustomizers(this.callCustomizers);
    }

    public List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> getCallCustomizers() {
        return this.callCustomizers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncHttpClientCallFactory)) {
            return false;
        }
        AsyncHttpClientCallFactory other = (AsyncHttpClientCallFactory)o;
        AsyncHttpClient this$httpClient = this.getHttpClient();
        AsyncHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        Supplier<AsyncHttpClient> this$httpClientSupplier = this.httpClientSupplier;
        Supplier<AsyncHttpClient> other$httpClientSupplier = other.httpClientSupplier;
        if (this$httpClientSupplier == null ? other$httpClientSupplier != null : !this$httpClientSupplier.equals(other$httpClientSupplier)) {
            return false;
        }
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> this$callCustomizers = this.getCallCustomizers();
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> other$callCustomizers = other.getCallCustomizers();
        return !(this$callCustomizers == null ? other$callCustomizers != null : !((Object)this$callCustomizers).equals(other$callCustomizers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AsyncHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        Supplier<AsyncHttpClient> $httpClientSupplier = this.httpClientSupplier;
        result = result * 59 + ($httpClientSupplier == null ? 43 : $httpClientSupplier.hashCode());
        List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> $callCustomizers = this.getCallCustomizers();
        result = result * 59 + ($callCustomizers == null ? 43 : ((Object)$callCustomizers).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncHttpClientCallFactory(httpClient=" + this.getHttpClient() + ", httpClientSupplier=" + this.httpClientSupplier + ", callCustomizers=" + this.getCallCustomizers() + ")";
    }

    public static class AsyncHttpClientCallFactoryBuilder {
        private AsyncHttpClient httpClient;
        private Supplier<AsyncHttpClient> httpClientSupplier;
        private ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;

        AsyncHttpClientCallFactoryBuilder() {
        }

        public AsyncHttpClientCallFactoryBuilder httpClient(AsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder httpClientSupplier(Supplier<AsyncHttpClient> httpClientSupplier) {
            this.httpClientSupplier = httpClientSupplier;
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizer(Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder> callCustomizer) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.add(callCustomizer);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder callCustomizers(Collection<? extends Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers) {
            if (this.callCustomizers == null) {
                this.callCustomizers = new ArrayList();
            }
            this.callCustomizers.addAll(callCustomizers);
            return this;
        }

        public AsyncHttpClientCallFactoryBuilder clearCallCustomizers() {
            if (this.callCustomizers != null) {
                this.callCustomizers.clear();
            }
            return this;
        }

        public AsyncHttpClientCallFactory build() {
            List<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>> callCustomizers;
            switch (this.callCustomizers == null ? 0 : this.callCustomizers.size()) {
                case 0: {
                    callCustomizers = Collections.emptyList();
                    break;
                }
                case 1: {
                    callCustomizers = Collections.singletonList(this.callCustomizers.get(0));
                    break;
                }
                default: {
                    callCustomizers = Collections.unmodifiableList(new ArrayList<Consumer<AsyncHttpClientCall.AsyncHttpClientCallBuilder>>(this.callCustomizers));
                }
            }
            return new AsyncHttpClientCallFactory(this.httpClient, this.httpClientSupplier, callCustomizers);
        }

        public String toString() {
            return "AsyncHttpClientCallFactory.AsyncHttpClientCallFactoryBuilder(httpClient=" + this.httpClient + ", httpClientSupplier=" + this.httpClientSupplier + ", callCustomizers=" + this.callCustomizers + ")";
        }
    }
}

