/*
 * Decompiled with CFR 0.152.
 */
package org.asynchttpclient.extras.retrofit;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import lombok.NonNull;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AsyncHttpClientCall
implements Cloneable,
Call {
    private static final Logger log = LoggerFactory.getLogger(AsyncHttpClientCall.class);
    public static final long DEFAULT_EXECUTE_TIMEOUT_MILLIS = 30000L;
    private final AtomicReference<CompletableFuture<okhttp3.Response>> futureRef = new AtomicReference();
    @NonNull
    private final AsyncHttpClient httpClient;
    private final long executeTimeoutMillis;
    @NonNull
    private final okhttp3.Request request;
    private final List<Consumer<RequestBuilder>> requestCustomizers;
    private final List<Consumer<okhttp3.Request>> onRequestStart;
    private final List<Consumer<Throwable>> onRequestFailure;
    private final List<Consumer<okhttp3.Response>> onRequestSuccess;

    protected static <T> void runConsumer(Consumer<T> consumer, T argument) {
        try {
            if (consumer != null) {
                consumer.accept(argument);
            }
        }
        catch (Exception e) {
            log.error("Exception while running consumer {}: {}", new Object[]{consumer, e.getMessage(), e});
        }
    }

    protected static <T> void runConsumers(Collection<Consumer<T>> consumers, T argument) {
        if (consumers == null || consumers.isEmpty()) {
            return;
        }
        consumers.forEach(consumer -> AsyncHttpClientCall.runConsumer(consumer, argument));
    }

    public okhttp3.Request request() {
        return this.request;
    }

    public okhttp3.Response execute() throws IOException {
        try {
            return this.executeHttpRequest().get(this.getExecuteTimeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            throw this.toIOException(e.getCause());
        }
        catch (Exception e) {
            throw this.toIOException(e);
        }
    }

    public void enqueue(Callback responseCallback) {
        ((CompletableFuture)this.executeHttpRequest().thenApply(response -> this.handleResponse((okhttp3.Response)response, responseCallback))).exceptionally(throwable -> (okhttp3.Response)this.handleException((Throwable)throwable, responseCallback));
    }

    public void cancel() {
        CompletableFuture<okhttp3.Response> future = this.futureRef.get();
        if (future != null && !future.cancel(true)) {
            log.warn("Cannot cancel future: {}", future);
        }
    }

    public boolean isExecuted() {
        CompletableFuture<okhttp3.Response> future = this.futureRef.get();
        return future != null && future.isDone();
    }

    public boolean isCanceled() {
        CompletableFuture<okhttp3.Response> future = this.futureRef.get();
        return future != null && future.isCancelled();
    }

    public Call clone() {
        return this.toBuilder().build();
    }

    protected <T> T handleException(Throwable throwable, Callback responseCallback) {
        try {
            if (responseCallback != null) {
                responseCallback.onFailure((Call)this, this.toIOException(throwable));
            }
        }
        catch (Exception e) {
            log.error("Exception while executing onFailure() on {}: {}", new Object[]{responseCallback, e.getMessage(), e});
        }
        return null;
    }

    protected okhttp3.Response handleResponse(okhttp3.Response response, Callback responseCallback) {
        try {
            if (responseCallback != null) {
                responseCallback.onResponse((Call)this, response);
            }
        }
        catch (Exception e) {
            log.error("Exception while executing onResponse() on {}: {}", new Object[]{responseCallback, e.getMessage(), e});
        }
        return response;
    }

    protected CompletableFuture<okhttp3.Response> executeHttpRequest() {
        CompletableFuture<okhttp3.Response> future;
        if (this.futureRef.get() != null) {
            this.throwAlreadyExecuted();
        }
        if (!this.futureRef.compareAndSet(null, future = new CompletableFuture<okhttp3.Response>())) {
            this.throwAlreadyExecuted();
        }
        Request asyncHttpClientRequest = this.createRequest(this.request());
        final AsyncHttpClientCall me = this;
        AsyncHttpClientCall.runConsumers(this.onRequestStart, this.request);
        this.getHttpClient().executeRequest(asyncHttpClientRequest, (AsyncHandler)new AsyncCompletionHandler<okhttp3.Response>(){

            public void onThrowable(Throwable t) {
                AsyncHttpClientCall.runConsumers(me.onRequestFailure, t);
                future.completeExceptionally(t);
            }

            public okhttp3.Response onCompleted(Response response) {
                okhttp3.Response okHttpResponse = AsyncHttpClientCall.this.toOkhttpResponse(response);
                AsyncHttpClientCall.runConsumers(me.onRequestSuccess, okHttpResponse);
                future.complete(okHttpResponse);
                return okHttpResponse;
            }
        });
        return future;
    }

    private okhttp3.Response toOkhttpResponse(Response asyncHttpClientResponse) {
        Response.Builder rspBuilder = new Response.Builder().request(this.request()).protocol(Protocol.HTTP_1_1).code(asyncHttpClientResponse.getStatusCode()).message(asyncHttpClientResponse.getStatusText());
        if (asyncHttpClientResponse.hasResponseHeaders()) {
            asyncHttpClientResponse.getHeaders().forEach(e -> rspBuilder.header((String)e.getKey(), (String)e.getValue()));
        }
        if (asyncHttpClientResponse.hasResponseBody()) {
            MediaType contentType = asyncHttpClientResponse.getContentType() == null ? null : MediaType.parse((String)asyncHttpClientResponse.getContentType());
            ResponseBody okHttpBody = ResponseBody.create((MediaType)contentType, (byte[])asyncHttpClientResponse.getResponseBodyAsBytes());
            rspBuilder.body(okHttpBody);
        }
        return rspBuilder.build();
    }

    protected IOException toIOException(@NonNull Throwable exception) {
        if (exception == null) {
            throw new NullPointerException("exception");
        }
        if (exception instanceof IOException) {
            return (IOException)exception;
        }
        String message = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        return new IOException(message, exception);
    }

    protected Request createRequest(@NonNull okhttp3.Request request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        RequestBuilder requestBuilder = new RequestBuilder(request.method());
        requestBuilder.setUrl(request.url().toString());
        Headers headers = request.headers();
        headers.names().forEach(name -> {
            RequestBuilder cfr_ignored_0 = (RequestBuilder)requestBuilder.setHeader((CharSequence)name, (Iterable)headers.values(name));
        });
        RequestBody body = request.body();
        if (body != null && body.contentLength() > 0L) {
            if (body.contentType() != null) {
                requestBuilder.setHeader((CharSequence)HttpHeaderNames.CONTENT_TYPE, body.contentType().toString());
            }
            Buffer okioBuffer = new Buffer();
            body.writeTo((BufferedSink)okioBuffer);
            requestBuilder.setBody(okioBuffer.readByteArray());
        }
        AsyncHttpClientCall.runConsumers(this.requestCustomizers, requestBuilder);
        return requestBuilder.build();
    }

    private void throwAlreadyExecuted() {
        throw new IllegalStateException("This call has already been executed.");
    }

    private static long $default$executeTimeoutMillis() {
        return 30000L;
    }

    AsyncHttpClientCall(@NonNull AsyncHttpClient httpClient, long executeTimeoutMillis, @NonNull okhttp3.Request request, List<Consumer<RequestBuilder>> requestCustomizers, List<Consumer<okhttp3.Request>> onRequestStart, List<Consumer<Throwable>> onRequestFailure, List<Consumer<okhttp3.Response>> onRequestSuccess) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient");
        }
        if (request == null) {
            throw new NullPointerException("request");
        }
        this.httpClient = httpClient;
        this.executeTimeoutMillis = executeTimeoutMillis;
        this.request = request;
        this.requestCustomizers = requestCustomizers;
        this.onRequestStart = onRequestStart;
        this.onRequestFailure = onRequestFailure;
        this.onRequestSuccess = onRequestSuccess;
    }

    public static AsyncHttpClientCallBuilder builder() {
        return new AsyncHttpClientCallBuilder();
    }

    public AsyncHttpClientCallBuilder toBuilder() {
        return new AsyncHttpClientCallBuilder().httpClient(this.httpClient).executeTimeoutMillis(this.executeTimeoutMillis).request(this.request).requestCustomizers(this.requestCustomizers).onRequestStart(this.onRequestStart).onRequestFailure(this.onRequestFailure).onRequestSuccess(this.onRequestSuccess);
    }

    public AtomicReference<CompletableFuture<okhttp3.Response>> getFutureRef() {
        return this.futureRef;
    }

    @NonNull
    public AsyncHttpClient getHttpClient() {
        return this.httpClient;
    }

    public long getExecuteTimeoutMillis() {
        return this.executeTimeoutMillis;
    }

    public List<Consumer<RequestBuilder>> getRequestCustomizers() {
        return this.requestCustomizers;
    }

    public List<Consumer<okhttp3.Request>> getOnRequestStart() {
        return this.onRequestStart;
    }

    public List<Consumer<Throwable>> getOnRequestFailure() {
        return this.onRequestFailure;
    }

    public List<Consumer<okhttp3.Response>> getOnRequestSuccess() {
        return this.onRequestSuccess;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AsyncHttpClientCall)) {
            return false;
        }
        AsyncHttpClientCall other = (AsyncHttpClientCall)o;
        AtomicReference<CompletableFuture<okhttp3.Response>> this$futureRef = this.getFutureRef();
        AtomicReference<CompletableFuture<okhttp3.Response>> other$futureRef = other.getFutureRef();
        if (this$futureRef == null ? other$futureRef != null : !this$futureRef.equals(other$futureRef)) {
            return false;
        }
        AsyncHttpClient this$httpClient = this.getHttpClient();
        AsyncHttpClient other$httpClient = other.getHttpClient();
        if (this$httpClient == null ? other$httpClient != null : !this$httpClient.equals(other$httpClient)) {
            return false;
        }
        if (this.getExecuteTimeoutMillis() != other.getExecuteTimeoutMillis()) {
            return false;
        }
        okhttp3.Request this$request = this.request;
        okhttp3.Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        List<Consumer<RequestBuilder>> this$requestCustomizers = this.getRequestCustomizers();
        List<Consumer<RequestBuilder>> other$requestCustomizers = other.getRequestCustomizers();
        if (this$requestCustomizers == null ? other$requestCustomizers != null : !((Object)this$requestCustomizers).equals(other$requestCustomizers)) {
            return false;
        }
        List<Consumer<okhttp3.Request>> this$onRequestStart = this.getOnRequestStart();
        List<Consumer<okhttp3.Request>> other$onRequestStart = other.getOnRequestStart();
        if (this$onRequestStart == null ? other$onRequestStart != null : !((Object)this$onRequestStart).equals(other$onRequestStart)) {
            return false;
        }
        List<Consumer<Throwable>> this$onRequestFailure = this.getOnRequestFailure();
        List<Consumer<Throwable>> other$onRequestFailure = other.getOnRequestFailure();
        if (this$onRequestFailure == null ? other$onRequestFailure != null : !((Object)this$onRequestFailure).equals(other$onRequestFailure)) {
            return false;
        }
        List<Consumer<okhttp3.Response>> this$onRequestSuccess = this.getOnRequestSuccess();
        List<Consumer<okhttp3.Response>> other$onRequestSuccess = other.getOnRequestSuccess();
        return !(this$onRequestSuccess == null ? other$onRequestSuccess != null : !((Object)this$onRequestSuccess).equals(other$onRequestSuccess));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicReference<CompletableFuture<okhttp3.Response>> $futureRef = this.getFutureRef();
        result = result * 59 + ($futureRef == null ? 43 : $futureRef.hashCode());
        AsyncHttpClient $httpClient = this.getHttpClient();
        result = result * 59 + ($httpClient == null ? 43 : $httpClient.hashCode());
        long $executeTimeoutMillis = this.getExecuteTimeoutMillis();
        result = result * 59 + (int)($executeTimeoutMillis >>> 32 ^ $executeTimeoutMillis);
        okhttp3.Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        List<Consumer<RequestBuilder>> $requestCustomizers = this.getRequestCustomizers();
        result = result * 59 + ($requestCustomizers == null ? 43 : ((Object)$requestCustomizers).hashCode());
        List<Consumer<okhttp3.Request>> $onRequestStart = this.getOnRequestStart();
        result = result * 59 + ($onRequestStart == null ? 43 : ((Object)$onRequestStart).hashCode());
        List<Consumer<Throwable>> $onRequestFailure = this.getOnRequestFailure();
        result = result * 59 + ($onRequestFailure == null ? 43 : ((Object)$onRequestFailure).hashCode());
        List<Consumer<okhttp3.Response>> $onRequestSuccess = this.getOnRequestSuccess();
        result = result * 59 + ($onRequestSuccess == null ? 43 : ((Object)$onRequestSuccess).hashCode());
        return result;
    }

    public String toString() {
        return "AsyncHttpClientCall(futureRef=" + this.getFutureRef() + ", httpClient=" + this.getHttpClient() + ", executeTimeoutMillis=" + this.getExecuteTimeoutMillis() + ", request=" + this.request + ", requestCustomizers=" + this.getRequestCustomizers() + ", onRequestStart=" + this.getOnRequestStart() + ", onRequestFailure=" + this.getOnRequestFailure() + ", onRequestSuccess=" + this.getOnRequestSuccess() + ")";
    }

    public static class AsyncHttpClientCallBuilder {
        private AsyncHttpClient httpClient;
        private boolean executeTimeoutMillis$set;
        private long executeTimeoutMillis;
        private okhttp3.Request request;
        private ArrayList<Consumer<RequestBuilder>> requestCustomizers;
        private ArrayList<Consumer<okhttp3.Request>> onRequestStart;
        private ArrayList<Consumer<Throwable>> onRequestFailure;
        private ArrayList<Consumer<okhttp3.Response>> onRequestSuccess;

        AsyncHttpClientCallBuilder() {
        }

        public AsyncHttpClientCallBuilder httpClient(AsyncHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public AsyncHttpClientCallBuilder executeTimeoutMillis(long executeTimeoutMillis) {
            this.executeTimeoutMillis = executeTimeoutMillis;
            this.executeTimeoutMillis$set = true;
            return this;
        }

        public AsyncHttpClientCallBuilder request(okhttp3.Request request) {
            this.request = request;
            return this;
        }

        public AsyncHttpClientCallBuilder requestCustomizer(Consumer<RequestBuilder> requestCustomizer) {
            if (this.requestCustomizers == null) {
                this.requestCustomizers = new ArrayList();
            }
            this.requestCustomizers.add(requestCustomizer);
            return this;
        }

        public AsyncHttpClientCallBuilder requestCustomizers(Collection<? extends Consumer<RequestBuilder>> requestCustomizers) {
            if (this.requestCustomizers == null) {
                this.requestCustomizers = new ArrayList();
            }
            this.requestCustomizers.addAll(requestCustomizers);
            return this;
        }

        public AsyncHttpClientCallBuilder clearRequestCustomizers() {
            if (this.requestCustomizers != null) {
                this.requestCustomizers.clear();
            }
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestStart(Consumer<okhttp3.Request> onRequestStart) {
            if (this.onRequestStart == null) {
                this.onRequestStart = new ArrayList();
            }
            this.onRequestStart.add(onRequestStart);
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestStart(Collection<? extends Consumer<okhttp3.Request>> onRequestStart) {
            if (this.onRequestStart == null) {
                this.onRequestStart = new ArrayList();
            }
            this.onRequestStart.addAll(onRequestStart);
            return this;
        }

        public AsyncHttpClientCallBuilder clearOnRequestStart() {
            if (this.onRequestStart != null) {
                this.onRequestStart.clear();
            }
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestFailure(Consumer<Throwable> onRequestFailure) {
            if (this.onRequestFailure == null) {
                this.onRequestFailure = new ArrayList();
            }
            this.onRequestFailure.add(onRequestFailure);
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestFailure(Collection<? extends Consumer<Throwable>> onRequestFailure) {
            if (this.onRequestFailure == null) {
                this.onRequestFailure = new ArrayList();
            }
            this.onRequestFailure.addAll(onRequestFailure);
            return this;
        }

        public AsyncHttpClientCallBuilder clearOnRequestFailure() {
            if (this.onRequestFailure != null) {
                this.onRequestFailure.clear();
            }
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestSuccess(Consumer<okhttp3.Response> onRequestSuccess) {
            if (this.onRequestSuccess == null) {
                this.onRequestSuccess = new ArrayList();
            }
            this.onRequestSuccess.add(onRequestSuccess);
            return this;
        }

        public AsyncHttpClientCallBuilder onRequestSuccess(Collection<? extends Consumer<okhttp3.Response>> onRequestSuccess) {
            if (this.onRequestSuccess == null) {
                this.onRequestSuccess = new ArrayList();
            }
            this.onRequestSuccess.addAll(onRequestSuccess);
            return this;
        }

        public AsyncHttpClientCallBuilder clearOnRequestSuccess() {
            if (this.onRequestSuccess != null) {
                this.onRequestSuccess.clear();
            }
            return this;
        }

        public AsyncHttpClientCall build() {
            List<Consumer<okhttp3.Response>> onRequestSuccess;
            List<Consumer<Throwable>> onRequestFailure;
            List<Consumer<okhttp3.Request>> onRequestStart;
            List<Consumer<RequestBuilder>> requestCustomizers;
            switch (this.requestCustomizers == null ? 0 : this.requestCustomizers.size()) {
                case 0: {
                    requestCustomizers = Collections.emptyList();
                    break;
                }
                case 1: {
                    requestCustomizers = Collections.singletonList(this.requestCustomizers.get(0));
                    break;
                }
                default: {
                    requestCustomizers = Collections.unmodifiableList(new ArrayList<Consumer<RequestBuilder>>(this.requestCustomizers));
                }
            }
            switch (this.onRequestStart == null ? 0 : this.onRequestStart.size()) {
                case 0: {
                    onRequestStart = Collections.emptyList();
                    break;
                }
                case 1: {
                    onRequestStart = Collections.singletonList(this.onRequestStart.get(0));
                    break;
                }
                default: {
                    onRequestStart = Collections.unmodifiableList(new ArrayList<Consumer<okhttp3.Request>>(this.onRequestStart));
                }
            }
            switch (this.onRequestFailure == null ? 0 : this.onRequestFailure.size()) {
                case 0: {
                    onRequestFailure = Collections.emptyList();
                    break;
                }
                case 1: {
                    onRequestFailure = Collections.singletonList(this.onRequestFailure.get(0));
                    break;
                }
                default: {
                    onRequestFailure = Collections.unmodifiableList(new ArrayList<Consumer<Throwable>>(this.onRequestFailure));
                }
            }
            switch (this.onRequestSuccess == null ? 0 : this.onRequestSuccess.size()) {
                case 0: {
                    onRequestSuccess = Collections.emptyList();
                    break;
                }
                case 1: {
                    onRequestSuccess = Collections.singletonList(this.onRequestSuccess.get(0));
                    break;
                }
                default: {
                    onRequestSuccess = Collections.unmodifiableList(new ArrayList<Consumer<okhttp3.Response>>(this.onRequestSuccess));
                }
            }
            long executeTimeoutMillis = this.executeTimeoutMillis;
            if (!this.executeTimeoutMillis$set) {
                executeTimeoutMillis = AsyncHttpClientCall.$default$executeTimeoutMillis();
            }
            return new AsyncHttpClientCall(this.httpClient, executeTimeoutMillis, this.request, requestCustomizers, onRequestStart, onRequestFailure, onRequestSuccess);
        }

        public String toString() {
            return "AsyncHttpClientCall.AsyncHttpClientCallBuilder(httpClient=" + this.httpClient + ", executeTimeoutMillis=" + this.executeTimeoutMillis + ", request=" + this.request + ", requestCustomizers=" + this.requestCustomizers + ", onRequestStart=" + this.onRequestStart + ", onRequestFailure=" + this.onRequestFailure + ", onRequestSuccess=" + this.onRequestSuccess + ")";
        }
    }
}

