/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.live.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.asteriskjava.live.AsteriskQueue;
import org.asteriskjava.live.AsteriskQueueEntry;
import org.asteriskjava.live.AsteriskQueueListener;
import org.asteriskjava.live.AsteriskQueueMember;
import org.asteriskjava.live.internal.AbstractLiveObject;
import org.asteriskjava.live.internal.AsteriskChannelImpl;
import org.asteriskjava.live.internal.AsteriskQueueEntryImpl;
import org.asteriskjava.live.internal.AsteriskQueueMemberImpl;
import org.asteriskjava.live.internal.AsteriskServerImpl;
import org.asteriskjava.util.AstUtil;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

class AsteriskQueueImpl
extends AbstractLiveObject
implements AsteriskQueue {
    private final Log logger = LogFactory.getLog(this.getClass());
    private final String name;
    private Integer max;
    private String strategy;
    private Integer serviceLevel;
    private Integer calls;
    private Integer holdTime;
    private Integer talkTime;
    private Integer completed;
    private Integer abandoned;
    private Double serviceLevelPerf;
    private Integer weight;
    private final List<AsteriskQueueEntryImpl> entries;
    private final Timer timer;
    private final Map<String, AsteriskQueueMemberImpl> members;
    private final List<AsteriskQueueListener> listeners;
    private final Map<AsteriskQueueEntry, ServiceLevelTimerTask> serviceLevelTimerTasks;

    AsteriskQueueImpl(AsteriskServerImpl server, String name, Integer max, String strategy, Integer serviceLevel, Integer weight, Integer calls, Integer holdTime, Integer talkTime, Integer completed, Integer abandoned, Double serviceLevelPerf) {
        super(server);
        this.name = name;
        this.max = max;
        this.strategy = strategy;
        this.serviceLevel = serviceLevel;
        this.weight = weight;
        this.entries = new ArrayList<AsteriskQueueEntryImpl>(25);
        this.listeners = new ArrayList<AsteriskQueueListener>();
        this.members = new HashMap<String, AsteriskQueueMemberImpl>();
        this.timer = new Timer("ServiceLevelTimer-" + name, true);
        this.serviceLevelTimerTasks = new HashMap<AsteriskQueueEntry, ServiceLevelTimerTask>();
        this.calls = calls;
        this.holdTime = holdTime;
        this.talkTime = talkTime;
        this.completed = completed;
        this.abandoned = abandoned;
        this.serviceLevelPerf = serviceLevelPerf;
        this.stampLastUpdate();
    }

    void cancelServiceLevelTimer() {
        this.timer.cancel();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Integer getMax() {
        return this.max;
    }

    @Override
    public String getStrategy() {
        return this.strategy;
    }

    boolean setMax(Integer max) {
        if (!AstUtil.isEqual(this.max, max)) {
            this.max = max;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getServiceLevel() {
        return this.serviceLevel;
    }

    boolean setServiceLevel(Integer serviceLevel) {
        if (!AstUtil.isEqual(this.serviceLevel, serviceLevel)) {
            this.serviceLevel = serviceLevel;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getCalls() {
        return this.calls;
    }

    boolean setCalls(Integer calls) {
        if (!AstUtil.isEqual(this.calls, calls)) {
            this.calls = calls;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getWaiting() {
        return this.calls;
    }

    @Override
    public Integer getHoldTime() {
        return this.holdTime;
    }

    boolean setHoldTime(Integer holdTime) {
        if (!AstUtil.isEqual(this.holdTime, holdTime)) {
            this.holdTime = holdTime;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getTalkTime() {
        return this.talkTime;
    }

    boolean setTalkTime(Integer talkTime) {
        if (!AstUtil.isEqual(this.talkTime, talkTime)) {
            this.talkTime = talkTime;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getCompleted() {
        return this.completed;
    }

    boolean setCompleted(Integer completed) {
        if (!AstUtil.isEqual(this.completed, completed)) {
            this.completed = completed;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getAbandoned() {
        return this.abandoned;
    }

    boolean setAbandoned(Integer abandoned) {
        if (!AstUtil.isEqual(this.abandoned, abandoned)) {
            this.abandoned = abandoned;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Double getServiceLevelPerf() {
        return this.serviceLevelPerf;
    }

    boolean setServiceLevelPerf(Double serviceLevelPerf) {
        if (!AstUtil.isEqual(this.serviceLevelPerf, serviceLevelPerf)) {
            this.serviceLevelPerf = serviceLevelPerf;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    @Override
    public Integer getWeight() {
        return this.weight;
    }

    boolean setWeight(Integer weight) {
        if (!AstUtil.isEqual(this.weight, weight)) {
            this.weight = weight;
            this.stampLastUpdate();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AsteriskQueueEntry> getEntries() {
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            return new ArrayList<AsteriskQueueEntry>(this.entries);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shift() {
        int currentPos = 1;
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            for (AsteriskQueueEntryImpl qe : this.entries) {
                if (qe.getPosition() != currentPos) {
                    qe.setPosition(currentPos);
                }
                ++currentPos;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createNewEntry(AsteriskChannelImpl channel, int reportedPosition, Date dateReceived) {
        AsteriskQueueEntryImpl qe = new AsteriskQueueEntryImpl(this.server, this, channel, reportedPosition, dateReceived);
        long delay = (long)this.serviceLevel.intValue() * 1000L;
        if (delay > 0L) {
            ServiceLevelTimerTask timerTask = new ServiceLevelTimerTask(qe);
            this.timer.schedule((TimerTask)timerTask, delay);
            Map<AsteriskQueueEntry, ServiceLevelTimerTask> map = this.serviceLevelTimerTasks;
            synchronized (map) {
                this.serviceLevelTimerTasks.put(qe, timerTask);
            }
        }
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            this.entries.add(qe);
            this.shift();
        }
        channel.setQueueEntry(qe);
        this.fireNewEntry(qe);
        this.server.fireNewQueueEntry(qe);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeEntry(AsteriskQueueEntryImpl entry, Date dateReceived) {
        boolean changed;
        Map<AsteriskQueueEntry, ServiceLevelTimerTask> map = this.serviceLevelTimerTasks;
        synchronized (map) {
            if (this.serviceLevelTimerTasks.containsKey(entry)) {
                ServiceLevelTimerTask timerTask = this.serviceLevelTimerTasks.get(entry);
                timerTask.cancel();
                this.serviceLevelTimerTasks.remove(entry);
            }
        }
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            changed = this.entries.remove(entry);
            if (changed) {
                this.shift();
            }
        }
        if (changed) {
            entry.getChannel().setQueueEntry(null);
            entry.left(dateReceived);
            this.fireEntryLeave(entry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder sb = new StringBuilder("AsteriskQueue[");
        sb.append("name='").append(this.getName()).append("',");
        sb.append("max='").append(this.getMax()).append("',");
        sb.append("strategy='").append(this.getStrategy()).append("',");
        sb.append("serviceLevel='").append(this.getServiceLevel()).append("',");
        sb.append("weight='").append(this.getWeight()).append("',");
        sb.append("calls='").append(this.getCalls()).append("',");
        sb.append("holdTime='").append(this.getHoldTime()).append("',");
        sb.append("talkTime='").append(this.getTalkTime()).append("',");
        sb.append("completed='").append(this.getCompleted()).append("',");
        sb.append("abandoned='").append(this.getAbandoned()).append("',");
        sb.append("serviceLevelPerf='").append(this.getServiceLevelPerf()).append("',");
        Object object = this.entries;
        synchronized (object) {
            sb.append("entries='").append(this.entries.toString()).append("',");
        }
        object = this.members;
        synchronized (object) {
            sb.append("members='").append(this.members.toString()).append("',");
        }
        sb.append("systemHashcode=").append(System.identityHashCode(this));
        sb.append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAsteriskQueueListener(AsteriskQueueListener listener) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireNewEntry(AsteriskQueueEntryImpl entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onNewEntry(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onNewEntry()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireEntryLeave(AsteriskQueueEntryImpl entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryLeave(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onEntryLeave()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberAdded(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberAdded(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberAdded()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberRemoved(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberRemoved(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberRemoved()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<AsteriskQueueMember> getMembers() {
        ArrayList<AsteriskQueueMember> listOfMembers = new ArrayList<AsteriskQueueMember>(this.members.size());
        Map<String, AsteriskQueueMemberImpl> map = this.members;
        synchronized (map) {
            listOfMembers.addAll(this.members.values());
        }
        return listOfMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMember(String location) {
        Map<String, AsteriskQueueMemberImpl> map = this.members;
        synchronized (map) {
            if (this.members.containsKey(location)) {
                return this.members.get(location);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addMember(AsteriskQueueMemberImpl member) {
        Map<String, AsteriskQueueMemberImpl> map = this.members;
        synchronized (map) {
            if (this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Adding new member to the queue " + this.getName() + ": " + member.toString());
            this.members.put(member.getLocation(), member);
        }
        this.fireMemberAdded(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueMemberImpl getMemberByLocation(String location) {
        AsteriskQueueMemberImpl member;
        Map<String, AsteriskQueueMemberImpl> map = this.members;
        synchronized (map) {
            member = this.members.get(location);
        }
        if (member == null) {
            this.logger.error("Requested member at location " + location + " not found!");
        }
        return member;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireMemberStateChanged(AsteriskQueueMemberImpl member) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onMemberStateChange(member);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in onMemberStateChange()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(String channelName) {
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            for (AsteriskQueueEntryImpl entry : this.entries) {
                if (!entry.getChannel().getName().equals(channelName)) continue;
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(AsteriskQueueMemberImpl member) {
        Map<String, AsteriskQueueMemberImpl> map = this.members;
        synchronized (map) {
            if (!this.members.containsValue(member)) {
                return;
            }
            this.logger.info("Remove member from the queue " + this.getName() + ": " + member.toString());
            this.members.remove(member.getLocation());
        }
        this.fireMemberRemoved(member);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireServiceLevelExceeded(AsteriskQueueEntry entry) {
        List<AsteriskQueueListener> list = this.listeners;
        synchronized (list) {
            for (AsteriskQueueListener listener : this.listeners) {
                try {
                    listener.onEntryServiceLevelExceeded(entry);
                }
                catch (Exception e) {
                    this.logger.warn("Exception in fireServiceLevelExceeded()", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AsteriskQueueEntryImpl getEntry(int position) {
        --position;
        AsteriskQueueEntryImpl foundEntry = null;
        List<AsteriskQueueEntryImpl> list = this.entries;
        synchronized (list) {
            try {
                foundEntry = this.entries.get(position);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return foundEntry;
    }

    private class ServiceLevelTimerTask
    extends TimerTask {
        private final AsteriskQueueEntry entry;

        ServiceLevelTimerTask(AsteriskQueueEntry entry) {
            this.entry = entry;
        }

        @Override
        public void run() {
            AsteriskQueueImpl.this.fireServiceLevelExceeded(this.entry);
        }
    }
}

