/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.Lists;
import com.google.common.collect.RangeMap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.data.MapEntry;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.guava.error.ShouldContainKeys;
import org.assertj.guava.error.ShouldContainValues;
import org.assertj.guava.util.ExceptionUtils;

public class RangeMapAssert<K extends Comparable<K>, V>
extends AbstractAssert<RangeMapAssert<K, V>, RangeMap<K, V>> {
    protected RangeMapAssert(RangeMap<K, V> actual) {
        super(actual, RangeMapAssert.class);
    }

    protected RangeMap<K, V> getActual() {
        return (RangeMap)this.actual;
    }

    public RangeMapAssert<K, V> containsKeys(K ... keys) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys == null, "The keys to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(keys.length == 0, "The keys to look for should not be empty", new Object[0]);
        LinkedHashSet keysNotFound = Sets.newLinkedHashSet();
        for (K key : keys) {
            if (((RangeMap)this.actual).get(key) != null) continue;
            keysNotFound.add(key);
        }
        if (!keysNotFound.isEmpty()) {
            throw this.assertionError(ShouldContainKeys.shouldContainKeys(this.actual, keys, keysNotFound));
        }
        return (RangeMapAssert)this.myself;
    }

    @SafeVarargs
    @Deprecated
    public final RangeMapAssert<K, V> contains(org.assertj.guava.data.MapEntry<K, V> ... entries) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries == null, "The entries to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries.length == 0, "The entries to look for should not be empty", new Object[0]);
        ArrayList entriesNotFound = Lists.newArrayList();
        for (org.assertj.guava.data.MapEntry<K, V> entry : entries) {
            Object value = ((RangeMap)this.actual).get((Comparable)entry.key);
            if (value != null && value.equals(entry.value)) continue;
            entriesNotFound.add(entry);
        }
        if (!entriesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContain.shouldContain((Object)this.actual, entries, (Object)entriesNotFound));
        }
        return (RangeMapAssert)this.myself;
    }

    @SafeVarargs
    public final RangeMapAssert<K, V> contains(MapEntry<K, V> ... entries) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries == null, "The entries to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(entries.length == 0, "The entries to look for should not be empty", new Object[0]);
        ArrayList entriesNotFound = Lists.newArrayList();
        for (MapEntry<K, V> entry : entries) {
            Object value = ((RangeMap)this.actual).get((Comparable)entry.key);
            if (value != null && value.equals(entry.value)) continue;
            entriesNotFound.add(entry);
        }
        if (!entriesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContain.shouldContain((Object)this.actual, entries, (Object)entriesNotFound));
        }
        return (RangeMapAssert)this.myself;
    }

    public RangeMapAssert<K, V> containsValues(V ... values) {
        this.isNotNull();
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values == null, "The values to look for should not be null", new Object[0]);
        ExceptionUtils.throwIllegalArgumentExceptionIfTrue(values.length == 0, "The values to look for should not be empty", new Object[0]);
        Map mapOfRanges = ((RangeMap)this.actual).asMapOfRanges();
        LinkedHashSet valuesNotFound = Sets.newLinkedHashSet();
        for (V value : values) {
            if (mapOfRanges.containsValue(value)) continue;
            valuesNotFound.add(value);
        }
        if (!valuesNotFound.isEmpty()) {
            throw this.assertionError(ShouldContainValues.shouldContainValues(this.actual, values, valuesNotFound));
        }
        return (RangeMapAssert)this.myself;
    }

    public RangeMapAssert<K, V> isEmpty() {
        this.isNotNull();
        if (!((RangeMap)this.actual).asMapOfRanges().isEmpty()) {
            throw this.assertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
        return (RangeMapAssert)this.myself;
    }

    public RangeMapAssert<K, V> isNotEmpty() {
        this.isNotNull();
        if (((RangeMap)this.actual).asMapOfRanges().isEmpty()) {
            throw this.assertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
        return (RangeMapAssert)this.myself;
    }
}

