/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.guava.api;

import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.error.ShouldBeEmpty;
import org.assertj.core.error.ShouldBeNullOrEmpty;
import org.assertj.core.error.ShouldContain;
import org.assertj.core.error.ShouldContainAnyOf;
import org.assertj.core.error.ShouldHaveSize;
import org.assertj.core.error.ShouldNotBeEmpty;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.ShouldNotContain;
import org.assertj.core.util.IterableUtil;
import org.assertj.guava.error.RangeSetShouldEnclose;
import org.assertj.guava.error.RangeSetShouldEncloseAnyOf;
import org.assertj.guava.error.RangeSetShouldIntersect;
import org.assertj.guava.error.RangeSetShouldIntersectAnyOf;
import org.assertj.guava.error.RangeSetShouldNotEnclose;
import org.assertj.guava.error.RangeSetShouldNotIntersect;

public class RangeSetAssert<T extends Comparable<T>>
extends AbstractAssert<RangeSetAssert<T>, RangeSet<T>> {
    protected RangeSetAssert(RangeSet<T> actual) {
        super(actual, RangeSetAssert.class);
    }

    public RangeSetAssert<T> hasSize(int size) {
        this.isNotNull();
        this.assertHasSize(size);
        return (RangeSetAssert)this.myself;
    }

    private void assertHasSize(int expectedSize) {
        int actualSize = ((RangeSet)this.actual).asRanges().size();
        if (actualSize != expectedSize) {
            this.throwAssertionError(ShouldHaveSize.shouldHaveSize((Object)this.actual, (int)actualSize, (int)expectedSize));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> contains(T ... values) {
        this.isNotNull();
        this.assertContains((Comparable[])values);
        return (RangeSetAssert)this.myself;
    }

    private void assertContains(T[] values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        if (((RangeSet)this.actual).isEmpty() && values.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetContainsGivenValues((RangeSet)this.actual, (Comparable[])values);
    }

    public RangeSetAssert<T> containsAll(Iterable<T> values) {
        this.isNotNull();
        this.assertContainsAll(values);
        return (RangeSetAssert)this.myself;
    }

    private void assertContainsAll(Iterable<T> values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        if (((RangeSet)this.actual).isEmpty() && !values.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetContainsGivenValues((RangeSet)this.actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetContainsGivenValues(RangeSet actual, Comparable[] values) {
        List elementsNotFound = Arrays.stream(values).filter(value -> !actual.contains(value)).collect(Collectors.toList());
        if (!elementsNotFound.isEmpty()) {
            this.throwAssertionError(ShouldContain.shouldContain((Object)actual, (Object)values, elementsNotFound));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> containsAnyOf(T ... values) {
        this.isNotNull();
        this.assertContainsAnyOf((Comparable[])values);
        return (RangeSetAssert)this.myself;
    }

    private void assertContainsAnyOf(T[] values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        if (((RangeSet)this.actual).isEmpty() && values.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetContainsAnyGivenValues((RangeSet)this.actual, (Comparable[])values);
    }

    public RangeSetAssert<T> containsAnyRangesOf(Iterable<T> values) {
        this.isNotNull();
        this.assertContainsAnyRangesOf(values);
        return (RangeSetAssert)this.myself;
    }

    private void assertContainsAnyRangesOf(Iterable<T> values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        if (((RangeSet)this.actual).isEmpty() && !values.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetContainsAnyGivenValues((RangeSet)this.actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetContainsAnyGivenValues(RangeSet actual, Comparable[] values) {
        boolean match = Arrays.stream(values).anyMatch(arg_0 -> ((RangeSet)actual).contains(arg_0));
        if (!match) {
            this.throwAssertionError(ShouldContainAnyOf.shouldContainAnyOf((Object)actual, (Object)values));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotContain(T ... values) {
        this.isNotNull();
        this.assertDoesNotContain((Comparable[])values);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotContain(T[] values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetDoesNotContainGivenValues((RangeSet)this.actual, (Comparable[])values);
    }

    public RangeSetAssert<T> doesNotContainAll(Iterable<T> values) {
        this.isNotNull();
        this.assertDoesNotContainAll(values);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotContainAll(Iterable<T> values) {
        Objects.requireNonNull(values, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"values")).create());
        RangeSetAssert.failIfEmpty(values, "values");
        this.assertRangeSetDoesNotContainGivenValues((RangeSet)this.actual, (Comparable[])IterableUtil.toArray(values, Comparable.class));
    }

    private void assertRangeSetDoesNotContainGivenValues(RangeSet actual, Comparable[] values) {
        List elementsFound = Arrays.stream(values).filter(arg_0 -> ((RangeSet)actual).contains(arg_0)).collect(Collectors.toList());
        if (!elementsFound.isEmpty()) {
            this.throwAssertionError(ShouldNotContain.shouldNotContain((Object)actual, (Object)values, elementsFound));
        }
    }

    public RangeSetAssert<T> isEmpty() {
        this.isNotNull();
        this.assertEmpty();
        return (RangeSetAssert)this.myself;
    }

    private void assertEmpty() {
        if (!((RangeSet)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeEmpty.shouldBeEmpty((Object)this.actual));
        }
    }

    public RangeSetAssert<T> isNotEmpty() {
        this.isNotNull();
        this.assertNotEmpty();
        return (RangeSetAssert)this.myself;
    }

    private void assertNotEmpty() {
        if (((RangeSet)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldNotBeEmpty.shouldNotBeEmpty());
        }
    }

    public RangeSetAssert<T> isNullOrEmpty() {
        this.assertNullOrEmpty();
        return (RangeSetAssert)this.myself;
    }

    private void assertNullOrEmpty() {
        if (this.actual != null && !((RangeSet)this.actual).isEmpty()) {
            this.throwAssertionError(ShouldBeNullOrEmpty.shouldBeNullOrEmpty((Object)this.actual));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> intersects(Range<T> ... ranges) {
        this.isNotNull();
        this.assertIntersects(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersects(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && ranges.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetIntersectsGivenValues(ranges);
    }

    public RangeSetAssert<T> intersectsAll(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertIntersectsAll(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersectsAll(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        if (((RangeSet)this.actual).isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetIntersectsGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    public RangeSetAssert<T> intersectsAll(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertIntersectsAll(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersectsAll(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && !ranges.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetIntersectsGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    private void assertRangeSetIntersectsGivenValues(Range<T>[] ranges) {
        List notIntersected = Arrays.stream(ranges).filter(range -> !((RangeSet)this.actual).intersects(range)).collect(Collectors.toList());
        if (!notIntersected.isEmpty()) {
            this.throwAssertionError(RangeSetShouldIntersect.shouldIntersect((RangeSet)this.actual, ranges, notIntersected));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> intersectsAnyOf(Range<T> ... ranges) {
        this.isNotNull();
        this.assertIntersectsAnyOf(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersectsAnyOf(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && ranges.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetIntersectsAnyOfGivenValues(ranges);
    }

    public RangeSetAssert<T> intersectsAnyRangesOf(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertIntersectsAnyRangesOf(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersectsAnyRangesOf(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && !ranges.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetIntersectsAnyOfGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    public RangeSetAssert<T> intersectsAnyRangesOf(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertIntersectsAnyRangesOf(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertIntersectsAnyRangesOf(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        if (((RangeSet)this.actual).isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetIntersectsAnyOfGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private void assertRangeSetIntersectsAnyOfGivenValues(Range<T>[] ranges) {
        boolean intersects = Arrays.stream(ranges).anyMatch(arg_0 -> ((RangeSet)((RangeSet)this.actual)).intersects(arg_0));
        if (!intersects) {
            this.throwAssertionError(RangeSetShouldIntersectAnyOf.shouldIntersectAnyOf((RangeSet)this.actual, ranges));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotIntersect(Range<T> ... ranges) {
        this.isNotNull();
        this.assertDoesNotIntersect(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotIntersect(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetDoesNotIntersectGivenValues(ranges);
    }

    public RangeSetAssert<T> doesNotIntersectAnyRangeFrom(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertDoesNotIntersectAnyRangeFrom(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotIntersectAnyRangeFrom(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetDoesNotIntersectGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    public RangeSetAssert<T> doesNotIntersectAnyRangeFrom(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertDoesNotIntersectAnyRangeFrom(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotIntersectAnyRangeFrom(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetDoesNotIntersectGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    private void assertRangeSetDoesNotIntersectGivenValues(Range<T>[] ranges) {
        List intersected = Arrays.stream(ranges).filter(arg_0 -> ((RangeSet)((RangeSet)this.actual)).intersects(arg_0)).collect(Collectors.toList());
        if (!intersected.isEmpty()) {
            this.throwAssertionError(RangeSetShouldNotIntersect.shouldNotIntersect(this.actual, ranges, intersected));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> encloses(Range<T> ... ranges) {
        this.isNotNull();
        this.assertEncloses(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertEncloses(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && ranges.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetEnclosesGivenValues(ranges);
    }

    public RangeSetAssert<T> enclosesAll(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertEnclosesAll(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertEnclosesAll(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && !ranges.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetEnclosesGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    public RangeSetAssert<T> enclosesAll(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertEnclosesAll(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertEnclosesAll(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        if (((RangeSet)this.actual).isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetEnclosesGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private void assertRangeSetEnclosesGivenValues(Range<T>[] ranges) {
        List notEnclosed = Arrays.stream(ranges).filter(range -> !((RangeSet)this.actual).encloses(range)).collect(Collectors.toList());
        if (!notEnclosed.isEmpty()) {
            this.throwAssertionError(RangeSetShouldEnclose.shouldEnclose(this.actual, ranges, notEnclosed));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> enclosesAnyOf(Range<T> ... ranges) {
        this.isNotNull();
        this.assertEnclosesAnyOf(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertEnclosesAnyOf(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && ranges.length == 0) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetEnclosesAnyOfGivenValues(ranges);
    }

    public RangeSetAssert<T> enclosesAnyRangesOf(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertEnclosesAnyRangesOf(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertEnclosesAnyRangesOf(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        if (((RangeSet)this.actual).isEmpty() && !ranges.iterator().hasNext()) {
            return;
        }
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetEnclosesAnyOfGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    public RangeSetAssert<T> enclosesAnyRangesOf(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertEnclosesAnyRangesOf(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertEnclosesAnyRangesOf(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        if (((RangeSet)this.actual).isEmpty() && rangeSet.isEmpty()) {
            return;
        }
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetEnclosesAnyOfGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private void assertRangeSetEnclosesAnyOfGivenValues(Range<T>[] ranges) {
        boolean match = Arrays.stream(ranges).anyMatch(arg_0 -> ((RangeSet)((RangeSet)this.actual)).encloses(arg_0));
        if (!match) {
            this.throwAssertionError(RangeSetShouldEncloseAnyOf.shouldEncloseAnyOf(this.actual, ranges));
        }
    }

    @SafeVarargs
    public final RangeSetAssert<T> doesNotEnclose(Range<T> ... ranges) {
        this.isNotNull();
        this.assertDoesNotEnclose(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotEnclose(Range<T>[] ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetDoesNotEncloseGivenValues(ranges);
    }

    public RangeSetAssert<T> doesNotEncloseAnyRangesOf(Iterable<Range<T>> ranges) {
        this.isNotNull();
        this.assertDoesNotEncloseAnyRangesOf(ranges);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotEncloseAnyRangesOf(Iterable<Range<T>> ranges) {
        Objects.requireNonNull(ranges, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"ranges")).create());
        RangeSetAssert.failIfEmpty(ranges, "ranges");
        this.assertRangeSetDoesNotEncloseGivenValues((Range[])IterableUtil.toArray(ranges, Range.class));
    }

    public RangeSetAssert<T> doesNotEncloseAnyRangesOf(RangeSet<T> rangeSet) {
        this.isNotNull();
        this.assertDoesNotEncloseAnyRangesOf(rangeSet);
        return (RangeSetAssert)this.myself;
    }

    private void assertDoesNotEncloseAnyRangesOf(RangeSet<T> rangeSet) {
        Objects.requireNonNull(rangeSet, () -> ((ShouldNotBeNull)ShouldNotBeNull.shouldNotBeNull((String)"rangeSet")).create());
        RangeSetAssert.failIfEmpty(rangeSet);
        this.assertRangeSetDoesNotEncloseGivenValues((Range[])IterableUtil.toArray((Iterable)rangeSet.asRanges(), Range.class));
    }

    private void assertRangeSetDoesNotEncloseGivenValues(Range<T>[] ranges) {
        List enclosed = Arrays.stream(ranges).filter(arg_0 -> ((RangeSet)((RangeSet)this.actual)).encloses(arg_0)).collect(Collectors.toList());
        if (!enclosed.isEmpty()) {
            this.throwAssertionError(RangeSetShouldNotEnclose.shouldNotEnclose(this.actual, ranges, enclosed));
        }
    }

    private static <T> void failIfEmpty(T[] array, String label) {
        if (array.length == 0) {
            throw new IllegalArgumentException("Expecting " + label + " not to be empty");
        }
    }

    private static <T> void failIfEmpty(Iterable<T> iterable, String label) {
        if (!iterable.iterator().hasNext()) {
            throw new IllegalArgumentException("Expecting " + label + " not to be empty");
        }
    }

    private static <T> void failIfEmpty(RangeSet<?> rangeSet) {
        if (rangeSet.isEmpty()) {
            throw new IllegalArgumentException("Expecting rangeSet not to be empty");
        }
    }
}

