/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.db.output;

import java.util.List;
import org.assertj.db.exception.AssertJDBException;
import org.assertj.db.navigation.PositionWithColumns;
import org.assertj.db.navigation.element.RowElement;
import org.assertj.db.navigation.origin.OriginWithValuesFromRow;
import org.assertj.db.output.AbstractOutputterWithOriginWithColumnsAndRowsFromChange;
import org.assertj.db.output.ChangeColumnOutputter;
import org.assertj.db.output.ChangeOutputter;
import org.assertj.db.output.ChangeRowValueOutputter;
import org.assertj.db.output.ChangesOutputter;
import org.assertj.db.output.impl.Output;
import org.assertj.db.type.Row;
import org.assertj.db.type.Value;
import org.assertj.db.util.Descriptions;

public class ChangeRowOutputter
extends AbstractOutputterWithOriginWithColumnsAndRowsFromChange<ChangeRowOutputter, ChangeOutputter>
implements RowElement,
OriginWithValuesFromRow<ChangesOutputter, ChangeOutputter, ChangeColumnOutputter, ChangeRowOutputter, ChangeRowValueOutputter> {
    private final PositionWithColumns<ChangeRowOutputter, ChangeRowValueOutputter, Value> valuePosition;
    private final Row row;

    public ChangeRowOutputter(ChangeOutputter origin, Row row) {
        super(ChangeRowOutputter.class, origin);
        this.row = row;
        this.valuePosition = new PositionWithColumns<ChangeRowOutputter, ChangeRowValueOutputter, Value>(this, ChangeRowValueOutputter.class){

            @Override
            protected String getDescription(int index) {
                List<String> columnsNameList = ChangeRowOutputter.this.row.getColumnsNameList();
                String columnName = columnsNameList.get(index);
                return Descriptions.getRowValueDescription(ChangeRowOutputter.this.info, index, columnName);
            }
        };
    }

    @Override
    public ChangeRowValueOutputter value() {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return (ChangeRowValueOutputter)((ChangeRowValueOutputter)this.valuePosition.getInstance(this.row.getValuesList())).withType(this.outputType);
    }

    @Override
    public ChangeRowValueOutputter value(int index) {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return (ChangeRowValueOutputter)((ChangeRowValueOutputter)this.valuePosition.getInstance(this.row.getValuesList(), index)).withType(this.outputType);
    }

    @Override
    public ChangeRowValueOutputter value(String columnName) {
        if (this.row == null) {
            throw new AssertJDBException("Row do not exist", new Object[0]);
        }
        return (ChangeRowValueOutputter)this.valuePosition.getInstance(this.row.getValuesList(), this.row.getColumnsNameList(), columnName, this.row.getColumnLetterCase()).withType(this.outputType);
    }

    public ChangeOutputter returnToChange() {
        return (ChangeOutputter)this.returnToOrigin();
    }

    @Override
    protected String getOutput(Output outputType) {
        return outputType.getRowOutput(this.info, this.row);
    }
}

