/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractStandardSoftAssertions;
import org.assertj.core.api.SoftAssertionError;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;

public class SoftAssertions
extends AbstractStandardSoftAssertions {
    private Extractor<Throwable, String> errorDescriptionExtractor = new Extractor<Throwable, String>(){

        @Override
        public String extract(Throwable throwable) {
            Throwable cause = throwable.getCause();
            if (cause == null) {
                return throwable.getMessage();
            }
            StackTraceElement[] stackTraceFirstElements = Arrays.copyOf(cause.getStackTrace(), 5);
            String stackTraceDescription = "";
            for (StackTraceElement stackTraceElement : stackTraceFirstElements) {
                stackTraceDescription = stackTraceDescription + String.format("\tat %s%n", stackTraceElement);
            }
            return String.format("%s%ncause message: %s%ncause first five stack trace elements:%n%s", throwable.getMessage(), cause.getMessage(), stackTraceDescription);
        }
    };

    public void assertAll() {
        List<Throwable> errors = this.errorsCollected();
        if (!errors.isEmpty()) {
            throw new SoftAssertionError(this.describeErrors(errors));
        }
    }

    private List<String> describeErrors(List<Throwable> errors) {
        return FieldsOrPropertiesExtractor.extract(errors, this.errorDescriptionExtractor);
    }

    public static void assertSoftly(Consumer<SoftAssertions> softly) {
        SoftAssertions assertions = new SoftAssertions();
        softly.accept(assertions);
        assertions.assertAll();
    }
}

