/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigDecimal;
import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.BigDecimals;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBigDecimalAssert<SELF extends AbstractBigDecimalAssert<SELF>>
extends AbstractComparableAssert<SELF, BigDecimal>
implements NumberAssert<SELF, BigDecimal> {
    @VisibleForTesting
    BigDecimals bigDecimals = BigDecimals.instance();

    public AbstractBigDecimalAssert(BigDecimal actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF isZero() {
        this.bigDecimals.assertIsZero(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.bigDecimals.assertIsNotZero(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.bigDecimals.assertIsOne(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.bigDecimals.assertIsPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.bigDecimals.assertIsNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.bigDecimals.assertIsNotPositive(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.bigDecimals.assertIsNotNegative(this.info, (Number)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    public SELF isEqualTo(String expected) {
        return (SELF)((AbstractBigDecimalAssert)this.isEqualTo(new BigDecimal(expected)));
    }

    @Override
    public SELF isEqualByComparingTo(String expected) {
        return (SELF)((AbstractBigDecimalAssert)this.isEqualByComparingTo(new BigDecimal(expected)));
    }

    @Override
    public SELF isNotEqualByComparingTo(String notExpected) {
        return (SELF)((AbstractBigDecimalAssert)this.isNotEqualByComparingTo(new BigDecimal(notExpected)));
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super BigDecimal> customComparator) {
        super.usingComparator(customComparator);
        this.bigDecimals = new BigDecimals(new ComparatorBasedComparisonStrategy(customComparator));
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bigDecimals = BigDecimals.instance();
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(BigDecimal expected, Offset<BigDecimal> offset) {
        this.bigDecimals.assertIsCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigDecimal expected, Offset<BigDecimal> offset) {
        this.bigDecimals.assertIsNotCloseTo(this.info, (Number)this.actual, expected, offset);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(BigDecimal expected, Percentage percentage) {
        this.bigDecimals.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigDecimal expected, Percentage percentage) {
        this.bigDecimals.assertIsNotCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }
}

