/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.DescriptionValidations;
import org.assertj.core.description.Description;
import org.assertj.core.presentation.BinaryRepresentation;
import org.assertj.core.presentation.HexadecimalRepresentation;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.assertj.core.presentation.UnicodeRepresentation;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;

public class WritableAssertionInfo
implements AssertionInfo {
    private String overridingErrorMessage;
    private Description description;
    private Representation representation;

    public WritableAssertionInfo(Representation customRepresentation) {
        this.useRepresentation(customRepresentation == null ? StandardRepresentation.STANDARD_REPRESENTATION : customRepresentation);
    }

    public WritableAssertionInfo() {
        this.useRepresentation(StandardRepresentation.STANDARD_REPRESENTATION);
    }

    @Override
    public String overridingErrorMessage() {
        return this.overridingErrorMessage;
    }

    public void overridingErrorMessage(String newErrorMessage) {
        this.overridingErrorMessage = newErrorMessage;
    }

    @Override
    public Description description() {
        return this.description;
    }

    public String descriptionText() {
        return this.description != null ? this.description.value() : null;
    }

    public void description(String newDescription, Object ... args) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription, args);
    }

    public void description(Description newDescription) {
        this.description = DescriptionValidations.checkIsNotNull(newDescription);
    }

    @Override
    public Representation representation() {
        return this.representation;
    }

    public void useHexadecimalRepresentation() {
        this.representation = new HexadecimalRepresentation();
    }

    public void useUnicodeRepresentation() {
        this.representation = new UnicodeRepresentation();
    }

    public void useBinaryRepresentation() {
        this.representation = new BinaryRepresentation();
    }

    public void useRepresentation(Representation newRepresentation) {
        Preconditions.checkNotNull(newRepresentation, "The representation to use should not be null.");
        this.representation = newRepresentation;
    }

    public String toString() {
        String format = "%s[overridingErrorMessage=%s, description=%s, representation=%s]";
        return String.format(format, this.getClass().getSimpleName(), Strings.quote(this.overridingErrorMessage()), Strings.quote(this.descriptionText()), Strings.quote(this.representation()));
    }
}

