/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractArrayAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.ByteArrays;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractByteArrayAssert<S extends AbstractByteArrayAssert<S>>
extends AbstractArrayAssert<S, byte[], Byte> {
    @VisibleForTesting
    protected ByteArrays arrays = ByteArrays.instance();

    public AbstractByteArrayAssert(byte[] actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public void isNullOrEmpty() {
        this.arrays.assertNullOrEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, (byte[])this.actual);
    }

    @Override
    public S isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, (byte[])this.actual);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S hasSize(int expected) {
        this.arrays.assertHasSize(this.info, (byte[])this.actual, expected);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(this.info, (byte[])this.actual, other);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S contains(byte ... values) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S contains(int ... values) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsOnly(byte ... values) {
        this.arrays.assertContainsOnly((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsOnly(int ... values) {
        this.arrays.assertContainsOnly((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsOnlyOnce(byte ... values) {
        this.arrays.assertContainsOnlyOnce((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsOnlyOnce(int ... values) {
        this.arrays.assertContainsOnlyOnce((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsSequence(byte ... sequence) {
        this.arrays.assertContainsSequence((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsSequence(int ... sequence) {
        this.arrays.assertContainsSequence((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsSubsequence(byte ... subsequence) {
        this.arrays.assertContainsSubsequence((AssertionInfo)this.info, (byte[])this.actual, subsequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsSubsequence(int ... subsequence) {
        this.arrays.assertContainsSubsequence((AssertionInfo)this.info, (byte[])this.actual, subsequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S contains(byte value, Index index) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S contains(int value, Index index) {
        this.arrays.assertContains((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S doesNotContain(byte ... values) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S doesNotContain(int ... values) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S doesNotContain(byte value, Index index) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S doesNotContain(int value, Index index) {
        this.arrays.assertDoesNotContain((AssertionInfo)this.info, (byte[])this.actual, value, index);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, (byte[])this.actual);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S startsWith(byte ... sequence) {
        this.arrays.assertStartsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S startsWith(int ... sequence) {
        this.arrays.assertStartsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S endsWith(byte ... sequence) {
        this.arrays.assertEndsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S endsWith(int ... sequence) {
        this.arrays.assertEndsWith((AssertionInfo)this.info, (byte[])this.actual, sequence);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S isSorted() {
        this.arrays.assertIsSorted(this.info, (byte[])this.actual);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S isSortedAccordingTo(Comparator<? super Byte> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, (byte[])this.actual, comparator);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S usingElementComparator(Comparator<? super Byte> customComparator) {
        this.arrays = new ByteArrays(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    @Override
    public S usingDefaultElementComparator() {
        this.arrays = ByteArrays.instance();
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsExactly(byte ... values) {
        this.objects.assertEqual(this.info, this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsExactly(int ... values) {
        this.objects.assertEqual(this.info, this.actual, this.arrays.toByteArray(values));
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsExactlyInAnyOrder(byte ... values) {
        this.arrays.assertContainsExactlyInAnyOrder((AssertionInfo)this.info, (byte[])this.actual, values);
        return (S)((AbstractByteArrayAssert)this.myself);
    }

    public S containsExactlyInAnyOrder(int ... values) {
        this.arrays.assertContainsExactlyInAnyOrder((AssertionInfo)this.info, (byte[])this.actual, this.arrays.toByteArray(values));
        return (S)((AbstractByteArrayAssert)this.myself);
    }
}

