/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractZonedDateTimeAssert<S extends AbstractZonedDateTimeAssert<S>>
extends AbstractAssert<S, ZonedDateTime> {
    public static final String NULL_DATE_TIME_PARAMETER_MESSAGE = "The ZonedDateTime to compare actual with should not be null";

    private static void assertDateTimeParameterIsNotNull(ZonedDateTime dateTime) {
        if (dateTime == null) {
            throw new IllegalArgumentException(NULL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }

    protected ZonedDateTime getActual() {
        return (ZonedDateTime)this.actual;
    }

    public S isBefore(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((ZonedDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isBefore(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBefore(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString));
    }

    public S isBeforeOrEqualTo(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((ZonedDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isBeforeOrEqualTo(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString));
    }

    public S isAfterOrEqualTo(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (((ZonedDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isAfterOrEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfterOrEqualTo(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString));
    }

    public S isAfter(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        if (!((ZonedDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isAfter(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return this.isAfter(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString));
    }

    public S isEqualToIgnoringNanos(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringNanos((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, otherInActualTimeZone));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringSeconds((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, otherInActualTimeZone));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringMinutes(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.areEqualIgnoringMinutes((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, otherInActualTimeZone));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringHours(ZonedDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractZonedDateTimeAssert.assertDateTimeParameterIsNotNull(other);
        ZonedDateTime otherInActualTimeZone = this.sameInstantInActualTimeZone(other);
        if (!AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth((ZonedDateTime)this.actual, otherInActualTimeZone)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, otherInActualTimeZone));
        }
        return (S)((AbstractZonedDateTimeAssert)this.myself);
    }

    public S isEqualTo(ZonedDateTime expected) {
        return (S)((AbstractZonedDateTimeAssert)super.isEqualTo(this.sameInstantInActualTimeZone(expected)));
    }

    public S isEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractZonedDateTimeAssert)super.isEqualTo(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString)));
    }

    public S isNotEqualTo(ZonedDateTime expected) {
        return (S)((AbstractZonedDateTimeAssert)super.isNotEqualTo(this.sameInstantInActualTimeZone(expected)));
    }

    public S isNotEqualTo(String dateTimeAsString) {
        AbstractZonedDateTimeAssert.assertDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractZonedDateTimeAssert)super.isNotEqualTo(this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimeAsString)));
    }

    public S isIn(ZonedDateTime ... expected) {
        return (S)((AbstractZonedDateTimeAssert)this.isIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public S isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    public S isNotIn(ZonedDateTime ... expected) {
        return (S)((AbstractZonedDateTimeAssert)this.isNotIn((Object[])this.changeToActualTimeZone(expected)));
    }

    public S isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return this.isNotIn(this.convertToDateTimeArray(dateTimesAsString));
    }

    private ZonedDateTime[] convertToDateTimeArray(String ... dateTimesAsString) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = this.parseStringAsIsoDateTimeAndMoveToActualTimeZone(dateTimesAsString[i]);
        }
        return dates;
    }

    private ZonedDateTime[] changeToActualTimeZone(ZonedDateTime ... dateTimes) {
        ZonedDateTime[] dates = new ZonedDateTime[dateTimes.length];
        for (int i = 0; i < dateTimes.length; ++i) {
            dates[i] = this.sameInstantInActualTimeZone(dateTimes[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given ZonedDateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given ZonedDateTime array should not be empty");
        }
    }

    private ZonedDateTime parseStringAsIsoDateTimeAndMoveToActualTimeZone(String dateTimeAsString) {
        ZonedDateTime zonedDateTime = ZonedDateTime.parse(dateTimeAsString, DateTimeFormatter.ISO_DATE_TIME);
        return this.sameInstantInActualTimeZone(zonedDateTime);
    }

    private ZonedDateTime sameInstantInActualTimeZone(ZonedDateTime zonedDateTime) {
        return zonedDateTime.withZoneSameInstant(((ZonedDateTime)this.actual).getZone());
    }

    private static void assertDateTimeAsStringParameterIsNotNull(String dateTimeAsString) {
        if (dateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the ZonedDateTime to compare actual with should not be null");
        }
    }

    private static boolean areEqualIgnoringNanos(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(ZonedDateTime actual, ZonedDateTime other) {
        return AbstractZonedDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(ZonedDateTime actual, ZonedDateTime other) {
        return actual.getYear() == other.getYear();
    }

    protected AbstractZonedDateTimeAssert(ZonedDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }
}

