/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractObjectArrayAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.Tuple;
import org.assertj.core.util.DoubleComparator;
import org.assertj.core.util.FloatComparator;

public abstract class AbstractObjectAssert<S extends AbstractObjectAssert<S, A>, A>
extends AbstractAssert<S, A> {
    private static final double DOUBLE_COMPARATOR_PRECISION = 1.0E-15;
    private static final float FLOAT_COMPARATOR_PRECISION = 1.0E-6f;
    private Map<String, Comparator<?>> comparatorByPropertyOrField = new HashMap();
    private Map<Class<?>, Comparator<?>> comparatorByType = AbstractObjectAssert.defaultTypeComparators();

    public AbstractObjectAssert(A actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public static Map<Class<?>, Comparator<?>> defaultTypeComparators() {
        HashMap comparatorByType = new HashMap();
        comparatorByType.put(Double.class, new DoubleComparator(1.0E-15));
        comparatorByType.put(Float.class, new FloatComparator(1.0E-6f));
        return comparatorByType;
    }

    public S isEqualToIgnoringNullFields(Object other) {
        this.objects.assertIsEqualToIgnoringNullFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToComparingOnlyGivenFields(Object other, String ... propertiesOrFieldsUsedInComparison) {
        this.objects.assertIsEqualToComparingOnlyGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, propertiesOrFieldsUsedInComparison);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToIgnoringGivenFields(Object other, String ... propertiesOrFieldsToIgnore) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, propertiesOrFieldsToIgnore);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasNoNullFieldsOrProperties() {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, new String[0]);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasNoNullFieldsOrPropertiesExcept(String ... propertiesOrFieldsToIgnore) {
        this.objects.assertHasNoNullFieldsOrPropertiesExcept(this.info, this.actual, propertiesOrFieldsToIgnore);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S isEqualToComparingFieldByField(Object other) {
        this.objects.assertIsEqualToIgnoringGivenFields(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType, new String[0]);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public <T> S usingComparatorForFields(Comparator<T> comparator, String ... propertiesOrFields) {
        for (String propertyOrField : propertiesOrFields) {
            this.comparatorByPropertyOrField.put(propertyOrField, comparator);
        }
        return (S)((AbstractObjectAssert)this.myself);
    }

    public <T> S usingComparatorForType(Comparator<T> comparator, Class<T> type) {
        this.comparatorByType.put(type, comparator);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasFieldOrProperty(String name) {
        this.objects.assertHasFieldOrProperty(this.info, this.actual, name);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public S hasFieldOrPropertyWithValue(String name, Object value) {
        this.objects.assertHasFieldOrPropertyWithValue(this.info, this.actual, name, value);
        return (S)((AbstractObjectAssert)this.myself);
    }

    public AbstractObjectArrayAssert<?, Object> extracting(String ... propertiesOrFields) {
        Tuple values = Extractors.byName(propertiesOrFields).extract(this.actual);
        return new ObjectArrayAssert<Object>(values.toArray());
    }

    @SafeVarargs
    public final AbstractObjectArrayAssert<?, Object> extracting(Function<? super A, Object> ... extractors) {
        Object[] values = Stream.of(extractors).map(extractor -> extractor.apply(this.actual)).toArray();
        return new ObjectArrayAssert<Object>(values);
    }

    public S isEqualToComparingFieldByFieldRecursively(Object other) {
        this.objects.assertIsEqualToComparingFieldByFieldRecursively(this.info, this.actual, other, this.comparatorByPropertyOrField, this.comparatorByType);
        return (S)((AbstractObjectAssert)this.myself);
    }
}

