/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;

public class Maps {
    public static String format(Map<?, ?> map) {
        return Maps.format(new StandardRepresentation(), map);
    }

    public static String format(Representation p, Map<?, ?> map) {
        if (map == null) {
            return null;
        }
        Map<?, ?> sortedMap = Maps.toSortedMapIfPossible(map);
        Iterator<Map.Entry<?, ?>> i = sortedMap.entrySet().iterator();
        if (!i.hasNext()) {
            return "{}";
        }
        StringBuilder builder = new StringBuilder("{");
        while (true) {
            Map.Entry<?, ?> entry = i.next();
            builder.append(Maps.format(map, entry.getKey(), p)).append('=').append(Maps.format(map, entry.getValue(), p));
            if (!i.hasNext()) {
                return builder.append("}").toString();
            }
            builder.append(", ");
        }
    }

    private static Map<?, ?> toSortedMapIfPossible(Map<?, ?> map) {
        try {
            return new TreeMap(map);
        }
        catch (ClassCastException | NullPointerException e) {
            return map;
        }
    }

    public static <K, V> Map<K, V> newHashMap(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(key, value);
        return map;
    }

    private static Object format(Map<?, ?> map, Object o, Representation p) {
        return o == map ? "(this Map)" : p.toStringOf(o);
    }

    private Maps() {
    }
}

