/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigDecimal;
import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.BigDecimals;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBigDecimalAssert<S extends AbstractBigDecimalAssert<S>>
extends AbstractComparableAssert<S, BigDecimal>
implements NumberAssert<S, BigDecimal> {
    @VisibleForTesting
    BigDecimals bigDecimals = BigDecimals.instance();

    protected AbstractBigDecimalAssert(BigDecimal actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public S isZero() {
        this.bigDecimals.assertIsZero(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isNotZero() {
        this.bigDecimals.assertIsNotZero(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isPositive() {
        this.bigDecimals.assertIsPositive(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isNegative() {
        this.bigDecimals.assertIsNegative(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isNotPositive() {
        this.bigDecimals.assertIsNotPositive(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isNotNegative() {
        this.bigDecimals.assertIsNotNegative(this.info, (Number)this.actual);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isStrictlyBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsStrictlyBetween(this.info, (Number)this.actual, start, end);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    public S isEqualTo(String expected) {
        return (S)((AbstractBigDecimalAssert)this.isEqualTo(new BigDecimal(expected)));
    }

    @Override
    public S isEqualByComparingTo(String expected) {
        return (S)((AbstractBigDecimalAssert)this.isEqualByComparingTo(new BigDecimal(expected)));
    }

    @Override
    public S isNotEqualByComparingTo(String expected) {
        return (S)((AbstractBigDecimalAssert)this.isNotEqualByComparingTo(new BigDecimal(expected)));
    }

    @Override
    public S usingComparator(Comparator<? super BigDecimal> customComparator) {
        super.usingComparator(customComparator);
        this.bigDecimals = new BigDecimals(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.bigDecimals = BigDecimals.instance();
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isCloseTo(BigDecimal other, Offset<BigDecimal> offset) {
        this.bigDecimals.assertIsCloseTo(this.info, (Number)this.actual, other, offset);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public S isCloseTo(BigDecimal expected, Percentage percentage) {
        this.bigDecimals.assertIsCloseToPercentage(this.info, (Number)this.actual, expected, percentage);
        return (S)((AbstractBigDecimalAssert)this.myself);
    }
}

