/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.LocalDateTime;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringHours;
import org.assertj.core.error.ShouldBeEqualIgnoringMinutes;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractLocalDateTimeAssert<S extends AbstractLocalDateTimeAssert<S>>
extends AbstractAssert<S, LocalDateTime> {
    public static final String NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE = "The LocalDateTime to compare actual with should not be null";

    protected AbstractLocalDateTimeAssert(LocalDateTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected LocalDateTime getActual() {
        return (LocalDateTime)this.actual;
    }

    public S isBefore(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isBefore(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBefore(LocalDateTime.parse(localDateTimeAsString));
    }

    public S isBeforeOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isBeforeOrEqualTo(LocalDateTime.parse(localDateTimeAsString));
    }

    public S isAfterOrEqualTo(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (((LocalDateTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isAfterOrEqualTo(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfterOrEqualTo(LocalDateTime.parse(localDateTimeAsString));
    }

    public S isAfter(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!((LocalDateTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isAfter(String localDateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(localDateTimeAsString);
        return this.isAfter(LocalDateTime.parse(localDateTimeAsString));
    }

    public S isEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractLocalDateTimeAssert)this.isEqualTo(LocalDateTime.parse(dateTimeAsString)));
    }

    public S isNotEqualTo(String dateTimeAsString) {
        AbstractLocalDateTimeAssert.assertLocalDateTimeAsStringParameterIsNotNull(dateTimeAsString);
        return (S)((AbstractLocalDateTimeAssert)this.isNotEqualTo(LocalDateTime.parse(dateTimeAsString)));
    }

    public S isIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractLocalDateTimeAssert)this.isIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    public S isNotIn(String ... dateTimesAsString) {
        this.checkIsNotNullAndNotEmpty(dateTimesAsString);
        return (S)((AbstractLocalDateTimeAssert)this.isNotIn(AbstractLocalDateTimeAssert.convertToLocalDateTimeArray(dateTimesAsString)));
    }

    private static Object[] convertToLocalDateTimeArray(String ... dateTimesAsString) {
        Object[] dates = new LocalDateTime[dateTimesAsString.length];
        for (int i = 0; i < dateTimesAsString.length; ++i) {
            dates[i] = LocalDateTime.parse(dateTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given LocalDateTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given LocalDateTime array should not be empty");
        }
    }

    private static void assertLocalDateTimeAsStringParameterIsNotNull(String localDateTimeAsString) {
        if (localDateTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the LocalDateTime to compare actual with should not be null");
        }
    }

    private static void assertLocalDateTimeParameterIsNotNull(LocalDateTime other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_LOCAL_DATE_TIME_PARAMETER_MESSAGE);
        }
    }

    public S isEqualToIgnoringNanos(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringNanos((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringSeconds((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringMinutes(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.areEqualIgnoringMinutes((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringMinutes.shouldBeEqualIgnoringMinutes(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    public S isEqualToIgnoringHours(LocalDateTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalDateTimeAssert.assertLocalDateTimeParameterIsNotNull(other);
        if (!AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth((LocalDateTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringHours.shouldBeEqualIgnoringHours(this.actual, other));
        }
        return (S)((AbstractLocalDateTimeAssert)this.myself);
    }

    private static boolean areEqualIgnoringNanos(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.areEqualIgnoringMinutes(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean areEqualIgnoringMinutes(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearMonthAndDayOfMonth(actual, other) && actual.getHour() == other.getHour();
    }

    private static boolean haveSameYearMonthAndDayOfMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYearAndMonth(actual, other) && actual.getDayOfMonth() == other.getDayOfMonth();
    }

    private static boolean haveSameYearAndMonth(LocalDateTime actual, LocalDateTime other) {
        return AbstractLocalDateTimeAssert.haveSameYear(actual, other) && actual.getMonth() == other.getMonth();
    }

    private static boolean haveSameYear(LocalDateTime actual, LocalDateTime other) {
        return actual.getYear() == other.getYear();
    }
}

