/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;

public final class FieldLocation
implements Comparable<FieldLocation> {
    private final String pathToUseInRules;
    private final List<String> decomposedPath;
    private final List<String> pathsHierarchyToUseInRules;

    public FieldLocation(List<String> path) {
        this.decomposedPath = Collections.unmodifiableList(Objects.requireNonNull(path, "path cannot be null"));
        this.pathToUseInRules = FieldLocation.pathToUseInRules(this.decomposedPath);
        this.pathsHierarchyToUseInRules = this.pathsHierarchyToUseInRules();
    }

    public FieldLocation(String s) {
        this(Lists.list(s.split("\\.")));
    }

    public boolean exactlyMatches(FieldLocation field) {
        return this.exactlyMatches(field.pathToUseInRules);
    }

    public boolean exactlyMatches(String fieldPath) {
        return this.pathToUseInRules.equals(fieldPath);
    }

    @Deprecated
    public boolean matches(String fieldPath) {
        return this.exactlyMatches(fieldPath);
    }

    @Deprecated
    public boolean matches(FieldLocation field) {
        return this.exactlyMatches(field);
    }

    public boolean hierarchyMatches(String fieldPath) {
        return this.pathsHierarchyToUseInRules.contains(fieldPath);
    }

    public boolean hierarchyMatchesRegex(Pattern regex) {
        return this.pathsHierarchyToUseInRules.stream().anyMatch(path -> regex.matcher((CharSequence)path).matches());
    }

    public List<String> getDecomposedPath() {
        return this.decomposedPath;
    }

    public String getPathToUseInRules() {
        return this.pathToUseInRules;
    }

    public FieldLocation field(String field) {
        ArrayList<String> decomposedPathWithField = new ArrayList<String>(this.decomposedPath);
        decomposedPathWithField.add(field);
        return new FieldLocation(decomposedPathWithField);
    }

    @Override
    public int compareTo(FieldLocation other) {
        return this.pathToUseInRules.compareTo(other.pathToUseInRules);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FieldLocation)) {
            return false;
        }
        FieldLocation that = (FieldLocation)obj;
        return Objects.equals(this.pathToUseInRules, that.pathToUseInRules) && Objects.equals(this.decomposedPath, that.decomposedPath) && Objects.equals(this.pathsHierarchyToUseInRules, that.pathsHierarchyToUseInRules);
    }

    public int hashCode() {
        return Objects.hash(this.pathToUseInRules, this.decomposedPath, this.pathsHierarchyToUseInRules);
    }

    public String toString() {
        return String.format("<%s>", this.pathToUseInRules);
    }

    public String shortDescription() {
        return this.pathToUseInRules;
    }

    private static String pathToUseInRules(List<String> path) {
        return path.stream().filter(subpath -> !subpath.startsWith("[")).collect(Collectors.joining("."));
    }

    public String getPathToUseInErrorReport() {
        return String.join((CharSequence)".", this.decomposedPath);
    }

    public String getFieldName() {
        if (this.decomposedPath.isEmpty()) {
            return "";
        }
        return this.decomposedPath.get(this.decomposedPath.size() - 1);
    }

    public boolean isRoot() {
        return this.pathToUseInRules.isEmpty();
    }

    public boolean isTopLevelField() {
        return !this.isRoot() && !this.pathToUseInRules.contains(".");
    }

    public static FieldLocation rootFieldLocation() {
        return new FieldLocation(Collections.emptyList());
    }

    public boolean hasParent(FieldLocation parent) {
        return this.pathToUseInRules.startsWith(parent.pathToUseInRules + ".");
    }

    public boolean hasChild(FieldLocation child) {
        return child.hasParent(this);
    }

    private List<String> pathsHierarchyToUseInRules() {
        List<FieldLocation> fieldAndParentFields = Lists.list(new FieldLocation[0]);
        FieldLocation currentLocation = this;
        while (!currentLocation.isRoot()) {
            fieldAndParentFields.add(currentLocation);
            currentLocation = currentLocation.parent();
        }
        return fieldAndParentFields.stream().map(fieldLocation -> fieldLocation.pathToUseInRules).collect(Collectors.toList());
    }

    private FieldLocation parent() {
        ArrayList<String> parentPath = new ArrayList<String>(this.decomposedPath);
        parentPath.remove(this.decomposedPath.size() - 1);
        return new FieldLocation(parentPath);
    }
}

