/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.error.GroupTypeDescription;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Strings;

public class ShouldContain
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldContain(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy) {
        GroupTypeDescription groupTypeDescription = GroupTypeDescription.getGroupTypeDescription(actual);
        return new ShouldContain(actual, expected, notFound, comparisonStrategy, groupTypeDescription);
    }

    public static ErrorMessageFactory shouldContain(Object actual, Object expected, Object notFound) {
        return ShouldContain.shouldContain(actual, expected, notFound, StandardComparisonStrategy.instance());
    }

    public static ErrorMessageFactory directoryShouldContain(File actual, List<String> directoryContent, String filterDescription) {
        return new ShouldContain(actual, directoryContent, filterDescription);
    }

    public static ErrorMessageFactory directoryShouldContain(Path actual, List<String> directoryContent, String filterDescription) {
        return new ShouldContain(actual, directoryContent, filterDescription);
    }

    private ShouldContain(Object actual, Object expected, Object notFound, ComparisonStrategy comparisonStrategy, GroupTypeDescription groupTypeDescription) {
        super("%nExpecting " + groupTypeDescription.getGroupTypeName() + ":%n <%s>%nto contain:%n <%s>%nbut could not find the following " + groupTypeDescription.getElementTypeName() + ":%n <%s>%n%s", actual, expected, notFound, comparisonStrategy);
    }

    private ShouldContain(Object actual, List<String> directoryContent, String filterDescription) {
        super("%nExpecting directory:%n  <%s>%nto contain at least one file matching " + Strings.escapePercent(filterDescription) + " but there was none.%nThe directory content was:%n  " + Strings.escapePercent(directoryContent.toString()), actual);
    }
}

