/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.annotations.Beta;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.FieldComparators;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;

@Beta
public class RecursiveComparisonConfiguration {
    public static final String INDENT_LEVEL_2 = "  -";
    private boolean strictTypeChecking = false;
    private boolean ignoreAllActualNullFields = false;
    private Set<FieldLocation> ignoredFields = new LinkedHashSet<FieldLocation>();
    private List<Pattern> ignoredFieldsRegexes = new ArrayList<Pattern>();
    private List<Class<?>> ignoredOverriddenEqualsForTypes = new ArrayList();
    private List<FieldLocation> ignoredOverriddenEqualsForFields = new ArrayList<FieldLocation>();
    private List<Pattern> ignoredOverriddenEqualsRegexes = new ArrayList<Pattern>();
    private boolean ignoreAllOverriddenEquals = false;
    private TypeComparators typeComparators = TypeComparators.defaultTypeComparators();
    private FieldComparators fieldComparators = new FieldComparators();

    public boolean hasComparatorForField(String fieldName) {
        return this.fieldComparators.hasComparatorForField(new FieldLocation(fieldName));
    }

    public Comparator<?> getComparatorForField(String fieldName) {
        return this.fieldComparators.getComparatorForField(new FieldLocation(fieldName));
    }

    public FieldComparators getFieldComparators() {
        return this.fieldComparators;
    }

    public boolean hasComparatorForType(Class<?> keyType) {
        return this.typeComparators.hasComparatorForType(keyType);
    }

    public boolean hasCustomComparators() {
        return !this.typeComparators.isEmpty() || !this.fieldComparators.isEmpty();
    }

    public Comparator<?> getComparatorForType(Class<?> fieldType) {
        return this.typeComparators.get(fieldType);
    }

    public TypeComparators getTypeComparators() {
        return this.typeComparators;
    }

    Stream<Map.Entry<Class<?>, Comparator<?>>> comparatorByTypes() {
        return this.typeComparators.comparatorByTypes();
    }

    @VisibleForTesting
    boolean getIgnoreAllActualNullFields() {
        return this.ignoreAllActualNullFields;
    }

    public void setIgnoreAllActualNullFields(boolean ignoreAllActualNullFields) {
        this.ignoreAllActualNullFields = ignoreAllActualNullFields;
    }

    public void ignoreFields(String ... fieldsToIgnore) {
        List<FieldLocation> fieldLocations = FieldLocation.from(fieldsToIgnore);
        this.ignoredFields.addAll(fieldLocations);
    }

    public void ignoreFieldsMatchingRegexes(String ... regexes) {
        this.ignoredFieldsRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public Set<FieldLocation> getIgnoredFields() {
        return this.ignoredFields;
    }

    public void ignoreAllOverriddenEquals() {
        this.ignoreAllOverriddenEquals = true;
    }

    public void ignoreOverriddenEqualsForFields(String ... fields) {
        List<FieldLocation> fieldLocations = FieldLocation.from(fields);
        this.ignoredOverriddenEqualsForFields.addAll(fieldLocations);
    }

    public void ignoreOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
        this.ignoredOverriddenEqualsRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public void ignoreOverriddenEqualsForTypes(Class<?> ... types) {
        this.ignoredOverriddenEqualsForTypes.addAll(Lists.list(types));
    }

    public <T> void registerComparatorForType(Comparator<? super T> comparator, Class<T> type) {
        this.typeComparators.put(type, comparator);
    }

    public void registerComparatorForField(Comparator<?> comparator, FieldLocation fieldLocation) {
        this.fieldComparators.registerComparator(fieldLocation, comparator);
    }

    public void strictTypeChecking(boolean strictTypeChecking) {
        this.strictTypeChecking = strictTypeChecking;
    }

    public boolean isInStrictTypeCheckingMode() {
        return this.strictTypeChecking;
    }

    public List<Pattern> getIgnoredFieldsRegexes() {
        return this.ignoredFieldsRegexes;
    }

    public List<Class<?>> getIgnoredOverriddenEqualsForTypes() {
        return this.ignoredOverriddenEqualsForTypes;
    }

    public List<FieldLocation> getIgnoredOverriddenEqualsForFields() {
        return this.ignoredOverriddenEqualsForFields;
    }

    public List<Pattern> getIgnoredOverriddenEqualsRegexes() {
        return this.ignoredOverriddenEqualsRegexes;
    }

    public Stream<Map.Entry<FieldLocation, Comparator<?>>> comparatorByFields() {
        return this.fieldComparators.comparatorByFields();
    }

    public String toString() {
        return this.multiLineDescription(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    public String multiLineDescription(Representation representation) {
        StringBuilder description = new StringBuilder();
        this.describeIgnoreAllActualNullFields(description);
        this.describeIgnoredFields(description);
        this.describeIgnoredFieldsRegexes(description);
        this.describeOverriddenEqualsMethodsUsage(description, representation);
        this.describeRegisteredComparatorByTypes(description);
        this.describeRegisteredComparatorForFields(description);
        this.describeTypeCheckingStrictness(description);
        return description.toString();
    }

    boolean shouldIgnore(DualValue dualKey) {
        return this.matchesAnIgnoredNullField(dualKey) || this.matchesAnIgnoredField(dualKey) || this.matchesAnIgnoredFieldRegex(dualKey);
    }

    Predicate<String> shouldKeepField(String parentConcatenatedPath) {
        return fieldName -> this.shouldKeepField(parentConcatenatedPath, (String)fieldName);
    }

    private boolean shouldKeepField(String parentPath, String fieldName) {
        String fieldConcatenatedPath = RecursiveComparisonConfiguration.concatenatedPath(parentPath, fieldName);
        return !this.matchesAnIgnoredField(fieldConcatenatedPath) && !this.matchesAnIgnoredFieldRegex(fieldConcatenatedPath);
    }

    private static String concatenatedPath(String parentPath, String name) {
        return parentPath.isEmpty() ? name : String.format("%s.%s", parentPath, name);
    }

    boolean shouldIgnoreOverriddenEqualsOf(DualValue dualKey) {
        if (dualKey.isJavaType()) {
            return false;
        }
        return this.ignoreAllOverriddenEquals || this.matchesAnIgnoredOverriddenEqualsField(dualKey) || this.shouldIgnoreOverriddenEqualsOf(dualKey.actual.getClass());
    }

    @VisibleForTesting
    boolean shouldIgnoreOverriddenEqualsOf(Class<? extends Object> clazz) {
        return this.matchesAnIgnoredOverriddenEqualsRegex(clazz) || this.matchesAnIgnoredOverriddenEqualsType(clazz);
    }

    private void describeIgnoredFieldsRegexes(StringBuilder description) {
        if (!this.ignoredFieldsRegexes.isEmpty()) {
            description.append(String.format("- the fields matching the following regexes were ignored in the comparison: %s%n", this.describeRegexes(this.ignoredFieldsRegexes)));
        }
    }

    private void describeIgnoredFields(StringBuilder description) {
        if (!this.ignoredFields.isEmpty()) {
            description.append(String.format("- the following fields were ignored in the comparison: %s%n", this.describeIgnoredFields()));
        }
    }

    private void describeIgnoreAllActualNullFields(StringBuilder description) {
        if (this.ignoreAllActualNullFields) {
            description.append(String.format("- all actual null fields were ignored in the comparison%n", new Object[0]));
        }
    }

    private void describeOverriddenEqualsMethodsUsage(StringBuilder description, Representation representation) {
        boolean isConfiguredToIgnoreSomeOverriddenEqualsMethods = this.isConfiguredToIgnoreSomeOverriddenEqualsMethods();
        String header = this.ignoreAllOverriddenEquals ? "- no overridden equals methods were used in the comparison except for java types" : "- overridden equals methods were used in the comparison";
        description.append(header);
        if (isConfiguredToIgnoreSomeOverriddenEqualsMethods) {
            description.append(String.format(this.ignoreAllOverriddenEquals ? " and:%n" : ", except for:%n", new Object[0]));
            this.describeIgnoredOverriddenEqualsMethods(description, representation);
        } else {
            description.append(String.format("%n", new Object[0]));
        }
    }

    private void describeIgnoredOverriddenEqualsMethods(StringBuilder description, Representation representation) {
        if (!this.ignoredOverriddenEqualsForFields.isEmpty()) {
            description.append(String.format("%s the following fields: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForFields()));
        }
        if (!this.ignoredOverriddenEqualsForTypes.isEmpty()) {
            description.append(String.format("%s the following types: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForTypes(representation)));
        }
        if (!this.ignoredOverriddenEqualsRegexes.isEmpty()) {
            description.append(String.format("%s the types matching the following regexes: %s%n", INDENT_LEVEL_2, this.describeRegexes(this.ignoredOverriddenEqualsRegexes)));
        }
    }

    private String describeIgnoredOverriddenEqualsForTypes(Representation representation) {
        List fieldsDescription = this.ignoredOverriddenEqualsForTypes.stream().map(representation::toStringOf).collect(Collectors.toList());
        return Strings.join(fieldsDescription).with(", ");
    }

    private String describeIgnoredOverriddenEqualsForFields() {
        List fieldsDescription = this.ignoredOverriddenEqualsForFields.stream().map(FieldLocation::getFieldPath).collect(Collectors.toList());
        return Strings.join(fieldsDescription).with(", ");
    }

    private boolean matchesAnIgnoredOverriddenEqualsRegex(Class<?> clazz) {
        if (this.ignoredOverriddenEqualsRegexes.isEmpty()) {
            return false;
        }
        String canonicalName = clazz.getCanonicalName();
        return this.ignoredOverriddenEqualsRegexes.stream().anyMatch(regex -> regex.matcher(canonicalName).matches());
    }

    private boolean matchesAnIgnoredOverriddenEqualsType(Class<?> clazz) {
        return this.ignoredOverriddenEqualsForTypes.contains(clazz);
    }

    private boolean matchesAnIgnoredOverriddenEqualsField(DualValue dualKey) {
        return this.ignoredOverriddenEqualsForFields.stream().anyMatch(fieldLocation -> fieldLocation.matches(dualKey.concatenatedPath));
    }

    private boolean matchesAnIgnoredNullField(DualValue dualKey) {
        return this.ignoreAllActualNullFields && dualKey.actual == null;
    }

    private boolean matchesAnIgnoredFieldRegex(String fieldConcatenatedPath) {
        return this.ignoredFieldsRegexes.stream().anyMatch(regex -> regex.matcher(fieldConcatenatedPath).matches());
    }

    private boolean matchesAnIgnoredFieldRegex(DualValue dualKey) {
        return this.matchesAnIgnoredFieldRegex(dualKey.concatenatedPath);
    }

    private boolean matchesAnIgnoredField(DualValue dualKey) {
        return this.matchesAnIgnoredField(dualKey.concatenatedPath);
    }

    private boolean matchesAnIgnoredField(String fieldConcatenatedPath) {
        return this.ignoredFields.stream().anyMatch(fieldLocation -> fieldLocation.matches(fieldConcatenatedPath));
    }

    private String describeIgnoredFields() {
        List fieldsDescription = this.ignoredFields.stream().map(FieldLocation::getFieldPath).collect(Collectors.toList());
        return Strings.join(fieldsDescription).with(", ");
    }

    private String describeRegexes(List<Pattern> regexes) {
        List fieldsDescription = regexes.stream().map(Pattern::pattern).collect(Collectors.toList());
        return Strings.join(fieldsDescription).with(", ");
    }

    private boolean isConfiguredToIgnoreSomeOverriddenEqualsMethods() {
        return !this.ignoredOverriddenEqualsRegexes.isEmpty() || !this.ignoredOverriddenEqualsForTypes.isEmpty() || !this.ignoredOverriddenEqualsForFields.isEmpty();
    }

    private void describeRegisteredComparatorByTypes(StringBuilder description) {
        if (!this.typeComparators.isEmpty()) {
            description.append(String.format("- these types were compared with the following comparators:%n", new Object[0]));
            this.describeComparatorForTypes(description);
        }
    }

    private void describeComparatorForTypes(StringBuilder description) {
        this.typeComparators.comparatorByTypes().map(this::formatRegisteredComparatorByType).forEach(description::append);
    }

    private String formatRegisteredComparatorByType(Map.Entry<Class<?>, Comparator<?>> next) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, next.getKey().getName(), next.getValue());
    }

    private void describeRegisteredComparatorForFields(StringBuilder description) {
        if (!this.fieldComparators.isEmpty()) {
            description.append(String.format("- these fields were compared with the following comparators:%n", new Object[0]));
            this.describeComparatorForFields(description);
            if (!this.typeComparators.isEmpty()) {
                description.append(String.format("- field comparators take precedence over type comparators.%n", new Object[0]));
            }
        }
    }

    private void describeComparatorForFields(StringBuilder description) {
        this.fieldComparators.comparatorByFields().map(this::formatRegisteredComparatorForField).forEach(description::append);
    }

    private String formatRegisteredComparatorForField(Map.Entry<FieldLocation, Comparator<?>> comparatorForField) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, comparatorForField.getKey().getFieldPath(), comparatorForField.getValue());
    }

    private void describeTypeCheckingStrictness(StringBuilder description) {
        String str = this.strictTypeChecking ? "- actual and expected objects and their fields were considered different when of incompatible types (i.e. expected type does not extend actual's type) even if all their fields match, for example a Person instance will never match a PersonDto (call strictTypeChecking(false) to change that behavior).%n" : "- actual and expected objects and their fields were compared field by field recursively even if they were not of the same type, this allows for example to compare a Person to a PersonDto (call strictTypeChecking(true) to change that behavior).%n";
        description.append(String.format(str, new Object[0]));
    }
}

