/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.util.Comparator;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.internal.Comparables;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public class AbstractStringAssert<SELF extends AbstractStringAssert<SELF>>
extends AbstractCharSequenceAssert<SELF, String> {
    @VisibleForTesting
    Comparables comparables = new Comparables();

    public AbstractStringAssert(String actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public SELF isLessThan(String other) {
        this.comparables.assertLessThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isLessThanOrEqualTo(String other) {
        this.comparables.assertLessThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isGreaterThan(String other) {
        this.comparables.assertGreaterThan(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isGreaterThanOrEqualTo(String other) {
        this.comparables.assertGreaterThanOrEqualTo(this.info, (Comparable)this.actual, other);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isBetween(String startInclusive, String endInclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startInclusive, endInclusive, true, true);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    public SELF isStrictlyBetween(String startExclusive, String endExclusive) {
        this.comparables.assertIsBetween(this.info, (Comparable)this.actual, startExclusive, endExclusive, false, false);
        return (SELF)((AbstractStringAssert)this.myself);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super String> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super String> customComparator, String customComparatorDescription) {
        this.comparables = new Comparables(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractStringAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.comparables = new Comparables();
        return (SELF)((AbstractStringAssert)super.usingDefaultComparator());
    }

    public SELF isEqualTo(String expectedStringTemplate, Object ... args) {
        return (SELF)((AbstractStringAssert)super.isEqualTo(String.format(expectedStringTemplate, args)));
    }
}

