/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.ArraySortedAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.api.Condition;
import org.assertj.core.api.IndexedObjectEnumerableAssert;
import org.assertj.core.api.ObjectArrayAssert;
import org.assertj.core.api.filter.FilterOperator;
import org.assertj.core.api.filter.Filters;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.api.iterable.ThrowingExtractor;
import org.assertj.core.data.Index;
import org.assertj.core.description.Description;
import org.assertj.core.extractor.Extractors;
import org.assertj.core.groups.FieldsOrPropertiesExtractor;
import org.assertj.core.groups.Tuple;
import org.assertj.core.internal.AtomicReferenceArrayElementComparisonStrategy;
import org.assertj.core.internal.CommonErrors;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ExtendedByTypesComparator;
import org.assertj.core.internal.FieldByFieldComparator;
import org.assertj.core.internal.IgnoringFieldsComparator;
import org.assertj.core.internal.Iterables;
import org.assertj.core.internal.ObjectArrays;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.OnFieldsComparator;
import org.assertj.core.internal.RecursiveFieldByFieldComparator;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public class AtomicReferenceArrayAssert<T>
extends AbstractAssert<AtomicReferenceArrayAssert<T>, AtomicReferenceArray<T>>
implements IndexedObjectEnumerableAssert<AtomicReferenceArrayAssert<T>, T>,
ArraySortedAssert<AtomicReferenceArrayAssert<T>, T> {
    private T[] array;
    @VisibleForTesting
    ObjectArrays arrays = ObjectArrays.instance();
    @VisibleForTesting
    Iterables iterables = Iterables.instance();
    private TypeComparators comparatorsByType;
    private Map<String, Comparator<?>> comparatorsForElementPropertyOrFieldNames = new TreeMap();
    private TypeComparators comparatorsForElementPropertyOrFieldTypes;

    public AtomicReferenceArrayAssert(AtomicReferenceArray<T> actual) {
        super(actual, AtomicReferenceArrayAssert.class);
        this.array = Arrays.array(actual);
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> as(Description description) {
        return (AtomicReferenceArrayAssert)super.as(description);
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> as(String description, Object ... args) {
        return (AtomicReferenceArrayAssert)super.as(description, args);
    }

    @Override
    public void isNullOrEmpty() {
        if (this.actual == null) {
            return;
        }
        this.isEmpty();
    }

    @Override
    public void isEmpty() {
        this.arrays.assertEmpty(this.info, this.array);
    }

    @Override
    public AtomicReferenceArrayAssert<T> isNotEmpty() {
        this.arrays.assertNotEmpty(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    public AtomicReferenceArrayAssert<T> hasArray(T[] expected) {
        this.arrays.assertContainsExactly(this.info, this.array, expected);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasSize(int expected) {
        this.arrays.assertHasSize(this.info, this.array, expected);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasSameSizeAs(Object other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.array, other);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasSameSizeAs(Iterable<?> other) {
        this.arrays.assertHasSameSizeAs((AssertionInfo)this.info, (Object[])this.array, other);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> contains(T ... values) {
        this.arrays.assertContains(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsOnly(T ... values) {
        this.arrays.assertContainsOnly(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsOnlyElementsOf(Iterable<? extends T> iterable) {
        return this.containsOnly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsOnlyNulls() {
        this.arrays.assertContainsOnlyNulls(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasSameElementsAs(Iterable<? extends T> iterable) {
        return this.containsOnlyElementsOf((Iterable)iterable);
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsOnlyOnce(T ... values) {
        this.arrays.assertContainsOnlyOnce(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsExactly(T ... values) {
        this.arrays.assertContainsExactly(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsExactlyInAnyOrder(T ... values) {
        this.arrays.assertContainsExactlyInAnyOrder(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsExactlyInAnyOrderElementsOf(Iterable<? extends T> values) {
        return this.containsExactlyInAnyOrder((Object[])IterableUtil.toArray(values));
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsExactlyElementsOf(Iterable<? extends T> iterable) {
        return this.containsExactly((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsSequence(T ... sequence) {
        this.arrays.assertContainsSequence(this.info, this.array, sequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsSequence(Iterable<? extends T> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertContainsSequence(this.info, this.array, IterableUtil.toArray(sequence));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainSequence(T ... sequence) {
        this.arrays.assertDoesNotContainSequence(this.info, this.array, sequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainSequence(Iterable<? extends T> sequence) {
        CommonValidations.checkSequenceIsNotNull(sequence);
        this.arrays.assertDoesNotContainSequence(this.info, this.array, IterableUtil.toArray(sequence));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsSubsequence(T ... subsequence) {
        this.arrays.assertContainsSubsequence(this.info, this.array, subsequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsSubsequence(Iterable<? extends T> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertContainsSubsequence(this.info, this.array, IterableUtil.toArray(subsequence));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainSubsequence(T ... subsequence) {
        this.arrays.assertDoesNotContainSubsequence(this.info, this.array, subsequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainSubsequence(Iterable<? extends T> subsequence) {
        CommonValidations.checkSubsequenceIsNotNull(subsequence);
        this.arrays.assertDoesNotContainSubsequence(this.info, this.array, IterableUtil.toArray(subsequence));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> contains(T value, Index index) {
        this.arrays.assertContains(this.info, this.array, value, index);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasOnlyElementsOfTypes(Class<?> ... types) {
        this.arrays.assertHasOnlyElementsOfTypes(this.info, this.array, types);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContain(T value, Index index) {
        this.arrays.assertDoesNotContain(this.info, this.array, value, index);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContain(T ... values) {
        this.arrays.assertDoesNotContain(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainAnyElementsOf(Iterable<? extends T> iterable) {
        this.arrays.assertDoesNotContainAnyElementsOf(this.info, this.array, iterable);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotHaveDuplicates() {
        this.arrays.assertDoesNotHaveDuplicates(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> startsWith(T ... sequence) {
        this.arrays.assertStartsWith(this.info, this.array, sequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> endsWith(T first, T ... sequence) {
        this.arrays.assertEndsWith(this.info, this.array, first, sequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> endsWith(T[] sequence) {
        this.arrays.assertEndsWith(this.info, this.array, sequence);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> isSubsetOf(Iterable<? extends T> values) {
        this.arrays.assertIsSubsetOf(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> isSubsetOf(T ... values) {
        this.arrays.assertIsSubsetOf(this.info, this.array, java.util.Arrays.asList(values));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsNull() {
        this.arrays.assertContainsNull(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotContainNull() {
        this.arrays.assertDoesNotContainNull(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> are(Condition<? super T> condition) {
        this.arrays.assertAre(this.info, this.array, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> areNot(Condition<? super T> condition) {
        this.arrays.assertAreNot(this.info, this.array, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> have(Condition<? super T> condition) {
        this.arrays.assertHave(this.info, this.array, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doNotHave(Condition<? super T> condition) {
        this.arrays.assertDoNotHave(this.info, this.array, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> areAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtLeast(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> areAtLeastOne(Condition<? super T> condition) {
        this.areAtLeast(1, (Condition)condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> areAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertAreAtMost(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> areExactly(int times, Condition<? super T> condition) {
        this.arrays.assertAreExactly(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> haveAtLeastOne(Condition<? super T> condition) {
        return this.haveAtLeast(1, (Condition)condition);
    }

    @Override
    public AtomicReferenceArrayAssert<T> haveAtLeast(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtLeast(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> haveAtMost(int times, Condition<? super T> condition) {
        this.arrays.assertHaveAtMost(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> haveExactly(int times, Condition<? super T> condition) {
        this.arrays.assertHaveExactly(this.info, this.array, times, condition);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasAtLeastOneElementOfType(Class<?> expectedType) {
        this.arrays.assertHasAtLeastOneElementOfType(this.info, this.array, expectedType);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> hasOnlyElementsOfType(Class<?> expectedType) {
        this.arrays.assertHasOnlyElementsOfType(this.info, this.array, expectedType);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> doesNotHaveAnyElementsOfTypes(Class<?> ... unexpectedTypes) {
        this.arrays.assertDoesNotHaveAnyElementsOfTypes(this.info, this.array, unexpectedTypes);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> isSorted() {
        this.arrays.assertIsSorted(this.info, this.array);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> isSortedAccordingTo(Comparator<? super T> comparator) {
        this.arrays.assertIsSortedAccordingToComparator(this.info, this.array, comparator);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsAll(Iterable<? extends T> iterable) {
        this.arrays.assertContainsAll(this.info, this.array, iterable);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingElementComparator(Comparator<? super T> elementComparator) {
        this.arrays = new ObjectArrays(new ComparatorBasedComparisonStrategy(elementComparator));
        this.objects = new Objects(new AtomicReferenceArrayElementComparisonStrategy<T>(elementComparator));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    private AtomicReferenceArrayAssert<T> usingExtendedByTypesElementComparator(Comparator<Object> elementComparator) {
        return this.usingElementComparator((Comparator)new ExtendedByTypesComparator(elementComparator, this.getComparatorsByType()));
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingDefaultElementComparator() {
        this.arrays = ObjectArrays.instance();
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @CheckReturnValue
    public <C> AtomicReferenceArrayAssert<T> usingComparatorForElementFieldsWithNames(Comparator<C> comparator, String ... elementPropertyOrFieldNames) {
        for (String elementPropertyOrField : elementPropertyOrFieldNames) {
            this.comparatorsForElementPropertyOrFieldNames.put(elementPropertyOrField, comparator);
        }
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @CheckReturnValue
    public <C> AtomicReferenceArrayAssert<T> usingComparatorForElementFieldsWithType(Comparator<C> comparator, Class<C> type) {
        this.getComparatorsForElementPropertyOrFieldTypes().put(type, comparator);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @CheckReturnValue
    public <C> AtomicReferenceArrayAssert<T> usingComparatorForType(Comparator<C> comparator, Class<C> type) {
        if (this.arrays.getComparator() == null) {
            this.usingElementComparator((Comparator)new ExtendedByTypesComparator(this.getComparatorsByType()));
        }
        this.getComparatorsForElementPropertyOrFieldTypes().put(type, comparator);
        this.getComparatorsByType().put(type, comparator);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new FieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes()));
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingRecursiveFieldByFieldElementComparator() {
        return this.usingExtendedByTypesElementComparator(new RecursiveFieldByFieldComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes()));
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingElementComparatorOnFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new OnFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> usingElementComparatorIgnoringFields(String ... fields) {
        return this.usingExtendedByTypesElementComparator(new IgnoringFieldsComparator(this.comparatorsForElementPropertyOrFieldNames, this.getComparatorsForElementPropertyOrFieldTypes(), fields));
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> extracting(String fieldOrProperty) {
        Object[] values = FieldsOrPropertiesExtractor.extract(this.array, Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> ObjectArrayAssert<P> extracting(String fieldOrProperty, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract(this.array, Extractors.byName(fieldOrProperty));
        String extractedDescription = Extractors.extractedDescriptionOf(fieldOrProperty);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public ObjectArrayAssert<Tuple> extracting(String ... propertiesOrFields) {
        Tuple[] values = FieldsOrPropertiesExtractor.extract(this.array, Extractors.byName(propertiesOrFields));
        Tuple[] result = (Tuple[])java.util.Arrays.copyOf(values, values.length, Tuple[].class);
        String extractedDescription = Extractors.extractedDescriptionOf(propertiesOrFields);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Tuple>(result).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <U> ObjectArrayAssert<U> extracting(Extractor<? super T, U> extractor) {
        U[] extracted = FieldsOrPropertiesExtractor.extract(this.array, extractor);
        return new ObjectArrayAssert<U>(extracted);
    }

    @CheckReturnValue
    public <U, EXCEPTION extends Exception> ObjectArrayAssert<U> extracting(ThrowingExtractor<? super T, U, EXCEPTION> extractor) {
        T[] extracted = FieldsOrPropertiesExtractor.extract(this.array, extractor);
        return new ObjectArrayAssert(extracted);
    }

    @CheckReturnValue
    public <U, C extends Collection<U>> ObjectArrayAssert<U> flatExtracting(Extractor<? super T, C> extractor) {
        return this.doFlatExtracting(extractor);
    }

    @CheckReturnValue
    public <U, C extends Collection<U>, EXCEPTION extends Exception> ObjectArrayAssert<U> flatExtracting(ThrowingExtractor<? super T, C, EXCEPTION> extractor) {
        return this.doFlatExtracting(extractor);
    }

    private <U, C extends Collection<U>> ObjectArrayAssert<U> doFlatExtracting(Extractor<? super T, C> extractor) {
        List result = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList(this.array), extractor).stream().flatMap(Collection::stream).collect(Collectors.toList());
        return new ObjectArrayAssert(IterableUtil.toArray(result));
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> flatExtracting(String propertyName) {
        ArrayList extractedValues = Lists.newArrayList();
        List<Object> extractedGroups = FieldsOrPropertiesExtractor.extract(java.util.Arrays.asList(this.array), Extractors.byName(propertyName));
        for (Object group : extractedGroups) {
            if (Arrays.isArray(group)) {
                int size = Array.getLength(group);
                for (int i = 0; i < size; ++i) {
                    extractedValues.add(Array.get(group, i));
                }
                continue;
            }
            if (group instanceof Iterable) {
                Iterable iterable = (Iterable)group;
                for (Object value : iterable) {
                    extractedValues.add(value);
                }
                continue;
            }
            CommonErrors.wrongElementTypeForFlatExtracting(group);
        }
        return new ObjectArrayAssert<Object>(extractedValues.toArray());
    }

    @CheckReturnValue
    public ObjectArrayAssert<Object> extractingResultOf(String method) {
        Object[] values = FieldsOrPropertiesExtractor.extract(this.array, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @CheckReturnValue
    public <P> ObjectArrayAssert<P> extractingResultOf(String method, Class<P> extractingType) {
        Object[] values = FieldsOrPropertiesExtractor.extract(this.array, Extractors.resultOf(method));
        String extractedDescription = Extractors.extractedDescriptionOfMethod(method);
        String description = Description.mostRelevantDescription(this.info.description(), extractedDescription);
        return (ObjectArrayAssert)new ObjectArrayAssert<Object>(values).as(description, new Object[0]);
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> inHexadecimal() {
        return (AtomicReferenceArrayAssert)super.inHexadecimal();
    }

    @Override
    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> inBinary() {
        return (AtomicReferenceArrayAssert)super.inBinary();
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> filteredOn(String propertyOrFieldName, Object expectedValue) {
        List<T> filteredIterable = Filters.filter(this.array).with(propertyOrFieldName, expectedValue).get();
        return new AtomicReferenceArrayAssert<T>(new AtomicReferenceArray<T>(IterableUtil.toArray(filteredIterable)));
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> filteredOnNull(String propertyOrFieldName) {
        return this.filteredOn(propertyOrFieldName, (Object)null);
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> filteredOn(String propertyOrFieldName, FilterOperator<?> filterOperator) {
        Preconditions.checkNotNull(filterOperator);
        Filters<T> filter = Filters.filter(this.array).with(propertyOrFieldName);
        filterOperator.applyOn(filter);
        return new AtomicReferenceArrayAssert<T>(new AtomicReferenceArray<T>(IterableUtil.toArray(filter.get())));
    }

    @CheckReturnValue
    public AtomicReferenceArrayAssert<T> filteredOn(Condition<? super T> condition) {
        List<? super T> filteredIterable = Filters.filter(this.array).being(condition).get();
        return new AtomicReferenceArrayAssert<T>(new AtomicReferenceArray<T>(IterableUtil.toArray(filteredIterable)));
    }

    @Override
    public AtomicReferenceArrayAssert<T> allMatch(Predicate<? super T> predicate) {
        this.iterables.assertAllMatch(this.info, Lists.newArrayList(this.array), predicate, PredicateDescription.GIVEN);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> allMatch(Predicate<? super T> predicate, String predicateDescription) {
        this.iterables.assertAllMatch(this.info, Lists.newArrayList(this.array), predicate, new PredicateDescription(predicateDescription));
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> allSatisfy(Consumer<? super T> requirements) {
        this.iterables.assertAllSatisfy(this.info, Lists.newArrayList(this.array), requirements);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> anyMatch(Predicate<? super T> predicate) {
        this.iterables.assertAnyMatch(this.info, Lists.newArrayList(this.array), predicate, PredicateDescription.GIVEN);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> anySatisfy(Consumer<? super T> requirements) {
        this.iterables.assertAnySatisfy(this.info, Lists.newArrayList(this.array), requirements);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> noneSatisfy(Consumer<? super T> restrictions) {
        this.iterables.assertNoneSatisfy(this.info, Lists.newArrayList(this.array), restrictions);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsAnyOf(T ... values) {
        this.arrays.assertContainsAnyOf(this.info, this.array, values);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    @Override
    public AtomicReferenceArrayAssert<T> containsAnyElementsOf(Iterable<? extends T> iterable) {
        return this.containsAnyOf((Object[])IterableUtil.toArray(iterable));
    }

    @Override
    public AtomicReferenceArrayAssert<T> noneMatch(Predicate<? super T> predicate) {
        this.iterables.assertNoneMatch(this.info, Lists.newArrayList(this.array), predicate, PredicateDescription.GIVEN);
        return (AtomicReferenceArrayAssert)this.myself;
    }

    protected TypeComparators getComparatorsByType() {
        if (this.comparatorsByType == null) {
            this.comparatorsByType = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsByType;
    }

    protected TypeComparators getComparatorsForElementPropertyOrFieldTypes() {
        if (this.comparatorsForElementPropertyOrFieldTypes == null) {
            this.comparatorsForElementPropertyOrFieldTypes = TypeComparators.defaultTypeComparators();
        }
        return this.comparatorsForElementPropertyOrFieldTypes;
    }
}

