/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.exception.RuntimeIOException;
import org.assertj.core.util.Lists;

public class URLs {
    public static String contentOf(URL url, String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return URLs.contentOf(url, Charset.forName(charsetName));
    }

    public static String contentOf(URL url, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("The charset should not be null");
        }
        try {
            return URLs.loadContents(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("The charset should not be null");
        }
        try {
            return URLs.loadLines(url.openStream(), charset);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unable to read " + url, e);
        }
    }

    public static List<String> linesOf(URL url, String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return URLs.linesOf(url, Charset.forName(charsetName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadContents(InputStream stream, Charset charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        boolean threw = true;
        try {
            int c;
            StringWriter writer = new StringWriter();
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
            threw = false;
            String string = writer.toString();
            return string;
        }
        finally {
            block8: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (threw) break block8;
                    throw e;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadLines(InputStream stream, Charset charset) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
        boolean threw = true;
        try {
            ArrayList<String> strings = Lists.newArrayList();
            String line = reader.readLine();
            while (line != null) {
                strings.add(line);
                line = reader.readLine();
            }
            threw = false;
            ArrayList<String> arrayList = strings;
            return arrayList;
        }
        finally {
            block8: {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    if (threw) break block8;
                    throw e;
                }
            }
        }
    }
}

