/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.GroupFormatUtil;
import org.assertj.core.util.Preconditions;

public class Arrays
extends GroupFormatUtil {
    private static final String NULL = "null";

    public static boolean isArray(Object o) {
        return o != null && o.getClass().isArray();
    }

    public static <T> boolean isNullOrEmpty(T[] array) {
        return array == null || Arrays.isEmpty(array);
    }

    @SafeVarargs
    public static <T> T[] array(T ... values) {
        return values;
    }

    public static <T> List<T> nonNullElementsIn(T[] array) {
        if (array == null) {
            return Collections.emptyList();
        }
        ArrayList<T> nonNullElements = new ArrayList<T>();
        for (T o : array) {
            if (o == null) continue;
            nonNullElements.add(o);
        }
        return nonNullElements;
    }

    public static <T> boolean hasOnlyNullElements(T[] array) {
        Preconditions.checkNotNull(array);
        if (Arrays.isEmpty(array)) {
            return false;
        }
        for (T o : array) {
            if (o == null) continue;
            return false;
        }
        return true;
    }

    public static String format(Representation representation, Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        return Arrays.isObjectArray(o) ? Arrays.smartFormat(representation, (Object[])o) : Arrays.formatPrimitiveArray(representation, o);
    }

    private static <T> boolean isEmpty(T[] array) {
        return array.length == 0;
    }

    private static boolean isObjectArray(Object o) {
        return Arrays.isArray(o) && !Arrays.isArrayTypePrimitive(o);
    }

    private static boolean isArrayTypePrimitive(Object o) {
        return o != null && o.getClass().getComponentType().isPrimitive();
    }

    static IllegalArgumentException notAnArrayOfPrimitives(Object o) {
        return new IllegalArgumentException(String.format("<%s> is not an array of primitives", o));
    }

    private static String smartFormat(Representation representation, Object[] iterable) {
        HashSet<Object[]> alreadyFormatted = new HashSet<Object[]>();
        String singleLineDescription = Arrays.singleLineFormat(representation, iterable, "[", "]", alreadyFormatted);
        return Arrays.doesDescriptionFitOnSingleLine(singleLineDescription) ? singleLineDescription : Arrays.multiLineFormat(representation, iterable, alreadyFormatted);
    }

    private static String singleLineFormat(Representation representation, Object[] iterable, String start, String end, Set<Object[]> alreadyFormatted) {
        return Arrays.format(representation, iterable, ",", " ", alreadyFormatted);
    }

    private static String multiLineFormat(Representation representation, Object[] iterable, Set<Object[]> alreadyFormatted) {
        return Arrays.format(representation, iterable, ELEMENT_SEPARATOR_WITH_NEWLINE, "    ", alreadyFormatted);
    }

    private static boolean doesDescriptionFitOnSingleLine(String singleLineDescription) {
        return singleLineDescription == null || singleLineDescription.length() < maxLengthForSingleLineDescription;
    }

    private static String format(Representation representation, Object[] array, String elementSeparator, String indentation, Set<Object[]> alreadyFormatted) {
        if (array == null) {
            return null;
        }
        if (array.length == 0) {
            return "[]";
        }
        StringBuilder desc = new StringBuilder();
        desc.append("[");
        alreadyFormatted.add(array);
        int i = 0;
        while (true) {
            Object element = array[i];
            if (i != 0) {
                desc.append(indentation);
            }
            if (!Arrays.isArray(element)) {
                desc.append(element == null ? NULL : representation.toStringOf(element));
            } else if (Arrays.isArrayTypePrimitive(element)) {
                desc.append(Arrays.formatPrimitiveArray(representation, element));
            } else if (alreadyFormatted.contains(element)) {
                desc.append("(this array)");
            } else {
                desc.append(Arrays.format(representation, (Object[])element, elementSeparator, indentation, alreadyFormatted));
            }
            if (i == array.length - 1) {
                alreadyFormatted.remove(array);
                return desc.append("]").toString();
            }
            desc.append(elementSeparator);
            ++i;
        }
    }

    private static String formatPrimitiveArray(Representation representation, Object o) {
        if (!Arrays.isArray(o)) {
            return null;
        }
        if (!Arrays.isArrayTypePrimitive(o)) {
            throw Arrays.notAnArrayOfPrimitives(o);
        }
        int size = Array.getLength(o);
        if (size == 0) {
            return "[]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        buffer.append(representation.toStringOf(Array.get(o, 0)));
        for (int i = 1; i < size; ++i) {
            buffer.append(",").append(" ").append(representation.toStringOf(Array.get(o, i)));
        }
        buffer.append("]");
        return buffer.toString();
    }

    private Arrays() {
    }
}

