/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.presentation;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Map;
import org.assertj.core.groups.Tuple;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Arrays;
import org.assertj.core.util.IterableUtil;
import org.assertj.core.util.Maps;

public final class DefaultToString {
    private static final String TUPPLE_START = "(";
    private static final String TUPPLE_END = ")";

    public static String toStringOf(Representation representation, Object o) {
        if (o instanceof Path) {
            return o.toString();
        }
        if (Arrays.isArray(o)) {
            return Arrays.format(representation, o);
        }
        if (o instanceof Collection) {
            return IterableUtil.smartFormat(representation, (Collection)o);
        }
        if (o instanceof Map) {
            return Maps.format(representation, (Map)o);
        }
        if (o instanceof Tuple) {
            return DefaultToString.toStringOf((Tuple)o, representation);
        }
        return o == null ? null : o.toString();
    }

    public static String toStringOf(Tuple tuple, Representation representation) {
        return IterableUtil.singleLineFormat(representation, tuple.toList(), TUPPLE_START, TUPPLE_END);
    }

    private DefaultToString() {
    }
}

