/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeEqual;
import org.assertj.core.error.ShouldBeEqualByComparingOnlyGivenFields;
import org.assertj.core.error.ShouldBeEqualToIgnoringFields;
import org.assertj.core.error.ShouldBeExactlyInstanceOf;
import org.assertj.core.error.ShouldBeIn;
import org.assertj.core.error.ShouldBeInstance;
import org.assertj.core.error.ShouldBeInstanceOfAny;
import org.assertj.core.error.ShouldBeOfClassIn;
import org.assertj.core.error.ShouldBeSame;
import org.assertj.core.error.ShouldHaveSameClass;
import org.assertj.core.error.ShouldHaveToString;
import org.assertj.core.error.ShouldNotBeEqual;
import org.assertj.core.error.ShouldNotBeExactlyInstanceOf;
import org.assertj.core.error.ShouldNotBeIn;
import org.assertj.core.error.ShouldNotBeInstance;
import org.assertj.core.error.ShouldNotBeInstanceOfAny;
import org.assertj.core.error.ShouldNotBeNull;
import org.assertj.core.error.ShouldNotBeOfClassIn;
import org.assertj.core.error.ShouldNotBeSame;
import org.assertj.core.error.ShouldNotHaveSameClass;
import org.assertj.core.internal.CommonValidations;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.FieldSupport;
import org.assertj.core.util.introspection.IntrospectionError;
import org.assertj.core.util.introspection.PropertySupport;

public class Objects {
    private static final Objects INSTANCE = new Objects();
    @VisibleForTesting
    final PropertySupport propertySupport = PropertySupport.instance();
    private final ComparisonStrategy comparisonStrategy;
    @VisibleForTesting
    Failures failures = Failures.instance();
    private final FieldSupport fieldSupport = FieldSupport.comparison();

    public static Objects instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    Objects() {
        this(StandardComparisonStrategy.instance());
    }

    public Objects(ComparisonStrategy comparisonStrategy) {
        this.comparisonStrategy = comparisonStrategy;
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.comparisonStrategy instanceof ComparatorBasedComparisonStrategy ? ((ComparatorBasedComparisonStrategy)this.comparisonStrategy).getComparator() : null;
    }

    @VisibleForTesting
    public ComparisonStrategy getComparisonStrategy() {
        return this.comparisonStrategy;
    }

    public void assertIsInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (!this.isInstanceOfClass(actual, type, info)) {
            throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(actual, type));
        }
    }

    public void assertIsInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        if (this.objectIsInstanceOfOneOfGivenClasses(actual, types, info)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeInstanceOfAny.shouldBeInstanceOfAny(actual, types));
    }

    private boolean objectIsInstanceOfOneOfGivenClasses(Object actual, Class<?>[] types, AssertionInfo info) {
        this.checkIsNotNullAndIsNotEmpty(types);
        this.assertNotNull(info, actual);
        for (Class<?> type : types) {
            if (type == null) {
                String format = "The given array of types:<%s> should not have null elements";
                throw new NullPointerException(String.format(format, info.representation().toStringOf(types)));
            }
            if (!type.isInstance(actual)) continue;
            return true;
        }
        return false;
    }

    public void assertIsNotInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (this.isInstanceOfClass(actual, type, info)) {
            throw this.failures.failure(info, ShouldNotBeInstance.shouldNotBeInstance(actual, type));
        }
    }

    private boolean isInstanceOfClass(Object actual, Class<?> clazz, AssertionInfo info) {
        this.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(clazz);
        return clazz.isInstance(actual);
    }

    public void assertIsNotInstanceOfAny(AssertionInfo info, Object actual, Class<?>[] types) {
        if (!this.objectIsInstanceOfOneOfGivenClasses(actual, types, info)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeInstanceOfAny.shouldNotBeInstanceOfAny(actual, types));
    }

    public void assertHasSameClassAs(AssertionInfo info, Object actual, Object other) {
        if (!this.haveSameClass(actual, other, info)) {
            throw this.failures.failure(info, ShouldHaveSameClass.shouldHaveSameClass(actual, other));
        }
    }

    private boolean haveSameClass(Object actual, Object other, AssertionInfo info) {
        this.assertNotNull(info, actual);
        if (other == null) {
            throw new NullPointerException("The given object should not be null");
        }
        Class<?> actualClass = actual.getClass();
        Class<?> otherClass = other.getClass();
        return actualClass.equals(otherClass);
    }

    public void assertDoesNotHaveSameClassAs(AssertionInfo info, Object actual, Object other) {
        if (this.haveSameClass(actual, other, info)) {
            throw this.failures.failure(info, ShouldNotHaveSameClass.shouldNotHaveSameClass(actual, other));
        }
    }

    public void assertIsExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (!this.actualIsExactlyInstanceOfType(actual, type, info)) {
            throw this.failures.failure(info, ShouldBeExactlyInstanceOf.shouldBeExactlyInstance(actual, type));
        }
    }

    private boolean actualIsExactlyInstanceOfType(Object actual, Class<?> expectedType, AssertionInfo info) {
        this.assertNotNull(info, actual);
        CommonValidations.checkTypeIsNotNull(expectedType);
        return expectedType.equals(actual.getClass());
    }

    public void assertIsNotExactlyInstanceOf(AssertionInfo info, Object actual, Class<?> type) {
        if (this.actualIsExactlyInstanceOfType(actual, type, info)) {
            throw this.failures.failure(info, ShouldNotBeExactlyInstanceOf.shouldNotBeExactlyInstance(actual, type));
        }
    }

    public void assertIsOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info);
        if (!itemInArray) {
            throw this.failures.failure(info, ShouldBeOfClassIn.shouldBeOfClassIn(actual, types));
        }
    }

    private boolean isOfOneOfGivenTypes(Object actual, Class<?>[] types, AssertionInfo info) {
        this.assertNotNull(info, actual);
        if (types == null) {
            throw new NullPointerException("The given types should not be null");
        }
        return this.isItemInArray(actual.getClass(), types);
    }

    public void assertIsNotOfAnyClassIn(AssertionInfo info, Object actual, Class<?>[] types) {
        boolean itemInArray = this.isOfOneOfGivenTypes(actual, types, info);
        if (itemInArray) {
            throw this.failures.failure(info, ShouldNotBeOfClassIn.shouldNotBeOfClassIn(actual, types));
        }
    }

    private void checkIsNotNullAndIsNotEmpty(Class<?>[] types) {
        if (types == null) {
            throw new NullPointerException("The given array of types should not be null");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("The given array of types should not be empty");
        }
    }

    public void assertEqual(AssertionInfo info, Object actual, Object expected) {
        if (this.areEqual(actual, expected)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, expected, this.comparisonStrategy, info.representation()));
    }

    public void assertNotEqual(AssertionInfo info, Object actual, Object other) {
        if (!this.areEqual(actual, other)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeEqual.shouldNotBeEqual(actual, other, this.comparisonStrategy));
    }

    private boolean areEqual(Object actual, Object other) {
        return this.comparisonStrategy.areEqual(actual, other);
    }

    public void assertNull(AssertionInfo info, Object actual) {
        if (actual == null) {
            return;
        }
        throw this.failures.failure(info, ShouldBeEqual.shouldBeEqual(actual, null, this.comparisonStrategy, info.representation()));
    }

    public void assertNotNull(AssertionInfo info, Object actual) {
        if (actual != null) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeNull.shouldNotBeNull());
    }

    public void assertSame(AssertionInfo info, Object actual, Object expected) {
        if (actual == expected) {
            return;
        }
        throw this.failures.failure(info, ShouldBeSame.shouldBeSame(actual, expected));
    }

    public void assertNotSame(AssertionInfo info, Object actual, Object other) {
        if (actual != other) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeSame.shouldNotBeSame(actual));
    }

    public void assertHasToString(AssertionInfo info, Object actual, String expectedToString) {
        this.assertNotNull(info, actual);
        if (!actual.toString().equals(expectedToString)) {
            throw this.failures.failure(info, ShouldHaveToString.shouldHaveToString(actual, expectedToString));
        }
    }

    public void assertIsIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isItemInArray(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Object[] values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isItemInArray(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new NullPointerException("The given array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given array should not be empty");
        }
    }

    private boolean isItemInArray(Object item, Object[] arrayOfValues) {
        for (Object value : arrayOfValues) {
            if (!this.areEqual(value, item)) continue;
            return true;
        }
        return false;
    }

    public void assertIsIn(AssertionInfo info, Object actual, Iterable<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldBeIn.shouldBeIn(actual, values, this.comparisonStrategy));
    }

    public void assertIsNotIn(AssertionInfo info, Object actual, Iterable<?> values) {
        this.checkIsNotNullAndNotEmpty(values);
        this.assertNotNull(info, actual);
        if (!this.isActualIn(actual, values)) {
            return;
        }
        throw this.failures.failure(info, ShouldNotBeIn.shouldNotBeIn(actual, values, this.comparisonStrategy));
    }

    private void checkIsNotNullAndNotEmpty(Iterable<?> values) {
        if (values == null) {
            throw new NullPointerException("The given iterable should not be null");
        }
        if (!values.iterator().hasNext()) {
            throw new IllegalArgumentException("The given iterable should not be empty");
        }
    }

    private boolean isActualIn(Object actual, Iterable<?> values) {
        for (Object value : values) {
            if (!this.areEqual(value, actual)) continue;
            return true;
        }
        return false;
    }

    public <A> void assertIsLenientEqualsToIgnoringNullFields(AssertionInfo info, A actual, A other) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<String> nullFields = new LinkedList<String>();
        for (Field field : Objects.getDeclaredFieldsIncludingInherited(actual.getClass())) {
            try {
                Object otherFieldValue = this.getFieldOrPropertyValue(other, field.getName());
                if (otherFieldValue == null) {
                    nullFields.add(field.getName());
                    continue;
                }
                Object actualFieldValue = this.getFieldOrPropertyValue(actual, field.getName());
                if (otherFieldValue.equals(actualFieldValue)) continue;
                fieldsNames.add(field.getName());
                rejectedValues.add(actualFieldValue);
                expectedValues.add(otherFieldValue);
            }
            catch (IntrospectionError introspectionError) {}
        }
        if (!fieldsNames.isEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, fieldsNames, rejectedValues, expectedValues, nullFields));
        }
    }

    public <A> void assertIsEqualToComparingOnlyGivenFields(AssertionInfo info, A actual, A other, String ... fields) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        ByFieldsComparison byFieldsComparison = this.isEqualToComparingOnlyGivenFields(actual, other, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualByComparingOnlyGivenFields.shouldBeEqualComparingOnlyGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToComparingOnlyGivenFields(A actual, A other, String[] fields) {
        LinkedList<String> rejectedFieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        for (String fieldName : fields) {
            Object otherFieldValue;
            Object actualFieldValue = this.getFieldOrPropertyValue(actual, fieldName);
            if (org.assertj.core.util.Objects.areEqual(actualFieldValue, otherFieldValue = this.getFieldOrPropertyValue(other, fieldName))) continue;
            rejectedFieldsNames.add(fieldName);
            expectedValues.add(otherFieldValue);
            rejectedValues.add(actualFieldValue);
        }
        return new ByFieldsComparison(rejectedFieldsNames, expectedValues, rejectedValues);
    }

    public <A> void assertIsEqualToIgnoringGivenFields(AssertionInfo info, A actual, A other, String ... fields) {
        this.assertNotNull(info, actual);
        this.assertOtherTypeIsCompatibleWithActualClass(info, other, actual.getClass());
        ByFieldsComparison byFieldsComparison = this.isEqualToIgnoringGivenFields(actual, other, fields);
        if (byFieldsComparison.isFieldsNamesNotEmpty()) {
            throw this.failures.failure(info, ShouldBeEqualToIgnoringFields.shouldBeEqualToIgnoringGivenFields(actual, byFieldsComparison.fieldsNames, byFieldsComparison.rejectedValues, byFieldsComparison.expectedValues, Lists.newArrayList(fields)));
        }
    }

    private <A> ByFieldsComparison isEqualToIgnoringGivenFields(A actual, A other, String[] givenIgnoredFields) {
        Set<Field> declaredFieldsIncludingInherited = Objects.getDeclaredFieldsIncludingInherited(actual.getClass());
        this.verifyIgnoredFieldsExist(actual, declaredFieldsIncludingInherited, givenIgnoredFields);
        LinkedList<String> fieldsNames = new LinkedList<String>();
        LinkedList<Object> expectedValues = new LinkedList<Object>();
        LinkedList<Object> rejectedValues = new LinkedList<Object>();
        LinkedHashSet<String> ignoredFields = Sets.newLinkedHashSet(givenIgnoredFields);
        for (Field field : declaredFieldsIncludingInherited) {
            Object otherFieldValue;
            Object actualFieldValue;
            if (ignoredFields.contains(field.getName()) || !this.canReadFieldValue(field, actual) || org.assertj.core.util.Objects.areEqual(actualFieldValue = this.getFieldOrPropertyValue(actual, field.getName()), otherFieldValue = this.getFieldOrPropertyValue(other, field.getName()))) continue;
            fieldsNames.add(field.getName());
            rejectedValues.add(actualFieldValue);
            expectedValues.add(otherFieldValue);
        }
        return new ByFieldsComparison(fieldsNames, expectedValues, rejectedValues);
    }

    private <A> boolean canReadFieldValue(Field field, A actual) {
        return this.fieldSupport.isAllowedToRead(field) || this.propertySupport.publicGetterExistsFor(field.getName(), actual);
    }

    private <A> void verifyIgnoredFieldsExist(A actual, Set<Field> declaredFields, String[] ignoredFields) {
        LinkedHashSet<String> ignoredFieldsNotDefined = Sets.newLinkedHashSet(ignoredFields);
        for (Field f : declaredFields) {
            ignoredFieldsNotDefined.remove(f.getName());
        }
        if (!ignoredFieldsNotDefined.isEmpty()) {
            throw new IllegalArgumentException(String.format("Fields to ignore <%s> not defined for type <%s>", ignoredFieldsNotDefined, actual.getClass().getCanonicalName()));
        }
    }

    private <A> Object getFieldOrPropertyValue(A a, String fieldName) {
        try {
            return this.fieldSupport.fieldValue(fieldName, Object.class, a);
        }
        catch (IntrospectionError e) {
            try {
                return this.propertySupport.propertyValueOf(fieldName, Object.class, a);
            }
            catch (IntrospectionError e2) {
                String msg = String.format("Unable to obtain the value of <'%s'> field/property from <%s>, expecting a public field or getter", fieldName, a);
                throw new IntrospectionError(msg);
            }
        }
    }

    private static Set<Field> getDeclaredFieldsIncludingInherited(Class<?> clazz) {
        if (clazz == null) {
            throw new NullPointerException("expecting Class parameter not to be null");
        }
        LinkedHashSet<Field> declaredFields = Sets.newLinkedHashSet(clazz.getDeclaredFields());
        for (Class<?> superclazz = clazz.getSuperclass(); superclazz != null && !superclazz.getName().startsWith("java.lang"); superclazz = superclazz.getSuperclass()) {
            declaredFields.addAll(Sets.newLinkedHashSet(superclazz.getDeclaredFields()));
        }
        return declaredFields;
    }

    private void assertOtherTypeIsCompatibleWithActualClass(AssertionInfo info, Object other, Class<?> clazz) {
        if (other == null) {
            throw this.failures.failure(info, ShouldBeInstance.shouldBeInstanceButWasNull("other", clazz));
        }
        this.isInstanceOf(other, clazz, info);
    }

    private void isInstanceOf(Object object, Class<?> clazz, AssertionInfo info) {
        if (!clazz.isInstance(object)) {
            throw this.failures.failure(info, ShouldBeInstance.shouldBeInstance(object, clazz));
        }
    }

    public boolean areEqualToIgnoringGivenFields(Object actual, Object other, String ... fields) {
        return this.isEqualToIgnoringGivenFields(actual, other, fields).isFieldsNamesEmpty();
    }

    public boolean areEqualToComparingOnlyGivenFields(Object actual, Object other, String ... fields) {
        return this.isEqualToComparingOnlyGivenFields(actual, other, fields).isFieldsNamesEmpty();
    }

    public static class ByFieldsComparison {
        private final List<String> fieldsNames;
        private final List<Object> expectedValues;
        private final List<Object> rejectedValues;

        public ByFieldsComparison(List<String> fieldsNames, List<Object> expectedValues, List<Object> rejectedValues) {
            this.fieldsNames = fieldsNames;
            this.expectedValues = expectedValues;
            this.rejectedValues = rejectedValues;
        }

        public ByFieldsComparison() {
            this(new ArrayList<String>(), new ArrayList<Object>(), new ArrayList<Object>());
        }

        public boolean isFieldsNamesEmpty() {
            return this.fieldsNames.isEmpty();
        }

        public boolean isFieldsNamesNotEmpty() {
            return !this.isFieldsNamesEmpty();
        }
    }
}

