/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.io.File;
import java.nio.charset.Charset;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.Files;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractFileAssert<S extends AbstractFileAssert<S>>
extends AbstractAssert<S, File> {
    @VisibleForTesting
    Files files = Files.instance();
    @VisibleForTesting
    Charset charset = Charset.defaultCharset();

    protected AbstractFileAssert(File actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S exists() {
        this.files.assertExists(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S doesNotExist() {
        this.files.assertDoesNotExist(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S isFile() {
        this.files.assertIsFile(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S isDirectory() {
        this.files.assertIsDirectory(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S isAbsolute() {
        this.files.assertIsAbsolute(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S isRelative() {
        this.files.assertIsRelative(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    @Deprecated
    public S hasContentEqualTo(File expected) {
        this.files.assertSameContentAs(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasSameContentAs(File expected) {
        this.files.assertSameContentAs(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasBinaryContent(byte[] expected) {
        this.files.assertHasBinaryContent(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S usingCharset(String charsetName) {
        if (!Charset.isSupported(charsetName)) {
            throw new IllegalArgumentException(String.format("Charset:<'%s'> is not supported on this system", charsetName));
        }
        return this.usingCharset(Charset.forName(charsetName));
    }

    public S usingCharset(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("The charset should not be null");
        }
        this.charset = charset;
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasContent(String expected) {
        this.files.assertHasContent(this.info, (File)this.actual, expected, this.charset);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S canWrite() {
        this.files.assertCanWrite(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S canRead() {
        this.files.assertCanRead(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasParent(File expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasParent(String expected) {
        this.files.assertHasParent(this.info, (File)this.actual, expected != null ? new File(expected) : null);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasExtension(String expected) {
        this.files.assertHasExtension(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasName(String expected) {
        this.files.assertHasName(this.info, (File)this.actual, expected);
        return (S)((AbstractFileAssert)this.myself);
    }

    public S hasNoParent() {
        this.files.assertHasNoParent(this.info, (File)this.actual);
        return (S)((AbstractFileAssert)this.myself);
    }
}

