/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.internal.Dates;
import org.assertj.core.util.DateUtil;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractDateAssert<S extends AbstractDateAssert<S>>
extends AbstractAssert<S, Date> {
    private static final List<DateFormat> DEFAULT_DATE_FORMATS = Lists.newArrayList(DateUtil.newIsoDateTimeWithMsFormat(), DateUtil.newTimestampDateFormat(), DateUtil.newIsoDateTimeFormat(), DateUtil.newIsoDateFormat());
    private static final String DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL = "Given date format pattern should not be null";
    private static final String DATE_FORMAT_SHOULD_NOT_BE_NULL = "Given date format should not be null";
    @VisibleForTesting
    static ThreadLocal<LinkedHashSet<DateFormat>> userDateFormats = new ThreadLocal<LinkedHashSet<DateFormat>>(){

        @Override
        protected LinkedHashSet<DateFormat> initialValue() {
            return new LinkedHashSet<DateFormat>();
        }
    };
    @VisibleForTesting
    Dates dates = Dates.instance();

    protected AbstractDateAssert(Date actual, Class<?> selfType) {
        super(actual, selfType);
    }

    public S isEqualTo(String dateAsString) {
        return (S)((AbstractDateAssert)this.isEqualTo(this.parse(dateAsString)));
    }

    public S isEqualToIgnoringHours(String dateAsString) {
        return this.isEqualToIgnoringHours(this.parse(dateAsString));
    }

    public S isEqualToIgnoringHours(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.HOURS);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isEqualToIgnoringMinutes(String dateAsString) {
        return this.isEqualToIgnoringMinutes(this.parse(dateAsString));
    }

    public S isEqualToIgnoringMinutes(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.MINUTES);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(String dateAsString) {
        return this.isEqualToIgnoringSeconds(this.parse(dateAsString));
    }

    public S isEqualToIgnoringSeconds(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.SECONDS);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isEqualToIgnoringMillis(String dateAsString) {
        return this.isEqualToIgnoringMillis(this.parse(dateAsString));
    }

    public S isEqualToIgnoringMillis(Date date) {
        this.dates.assertIsEqualWithPrecision(this.info, (Date)this.actual, date, TimeUnit.MILLISECONDS);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isNotEqualTo(String dateAsString) {
        return (S)((AbstractDateAssert)this.isNotEqualTo(this.parse(dateAsString)));
    }

    public S isIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = this.parse(datesAsString[i]);
        }
        return (S)((AbstractDateAssert)this.isIn(dates));
    }

    public S isInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(this.parse(dateAsString));
        }
        return (S)((AbstractDateAssert)this.isIn(dates));
    }

    public S isNotIn(String ... datesAsString) {
        Date[] dates = new Date[datesAsString.length];
        for (int i = 0; i < datesAsString.length; ++i) {
            dates[i] = this.parse(datesAsString[i]);
        }
        return (S)((AbstractDateAssert)this.isNotIn(dates));
    }

    public S isNotInWithStringDateCollection(Collection<String> datesAsString) {
        ArrayList<Date> dates = new ArrayList<Date>(datesAsString.size());
        for (String dateAsString : datesAsString) {
            dates.add(this.parse(dateAsString));
        }
        return (S)((AbstractDateAssert)this.isNotIn(dates));
    }

    public S isBefore(Date other) {
        this.dates.assertIsBefore(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBefore(String dateAsString) {
        return this.isBefore(this.parse(dateAsString));
    }

    public S isBeforeOrEqualsTo(Date other) {
        this.dates.assertIsBeforeOrEqualsTo(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBeforeOrEqualsTo(String dateAsString) {
        return this.isBeforeOrEqualsTo(this.parse(dateAsString));
    }

    public S isAfter(Date other) {
        this.dates.assertIsAfter(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfter(String dateAsString) {
        return this.isAfter(this.parse(dateAsString));
    }

    public S isAfterOrEqualsTo(Date other) {
        this.dates.assertIsAfterOrEqualsTo(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfterOrEqualsTo(String dateAsString) {
        return this.isAfterOrEqualsTo(this.parse(dateAsString));
    }

    public S isBetween(Date start, Date end) {
        return this.isBetween(start, end, true, false);
    }

    public S isBetween(String start, String end) {
        return this.isBetween(this.parse(start), this.parse(end));
    }

    public S isBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsBetween(this.info, (Date)this.actual, this.parse(start), this.parse(end), inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isNotBetween(Date start, Date end, boolean inclusiveStart, boolean inclusiveEnd) {
        this.dates.assertIsNotBetween(this.info, (Date)this.actual, start, end, inclusiveStart, inclusiveEnd);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isNotBetween(String start, String end, boolean inclusiveStart, boolean inclusiveEnd) {
        return this.isNotBetween(this.parse(start), this.parse(end), inclusiveStart, inclusiveEnd);
    }

    public S isNotBetween(Date start, Date end) {
        return this.isNotBetween(start, end, true, false);
    }

    public S isNotBetween(String start, String end) {
        return this.isNotBetween(this.parse(start), this.parse(end), true, false);
    }

    public S isInThePast() {
        this.dates.assertIsInThePast(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isToday() {
        this.dates.assertIsToday(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInTheFuture() {
        this.dates.assertIsInTheFuture(this.info, (Date)this.actual);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isBeforeYear(int year) {
        this.dates.assertIsBeforeYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isAfterYear(int year) {
        this.dates.assertIsAfterYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinYear(int year) {
        this.dates.assertIsWithinYear(this.info, (Date)this.actual, year);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMonth(int month) {
        this.dates.assertIsWithinMonth(this.info, (Date)this.actual, month);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinDayOfMonth(int dayOfMonth) {
        this.dates.assertIsWithinDayOfMonth(this.info, (Date)this.actual, dayOfMonth);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinDayOfWeek(int dayOfWeek) {
        this.dates.assertIsWithinDayOfWeek(this.info, (Date)this.actual, dayOfWeek);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinHourOfDay(int hourOfDay) {
        this.dates.assertIsWithinHourOfDay(this.info, (Date)this.actual, hourOfDay);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMinute(int minute) {
        this.dates.assertIsWithinMinute(this.info, (Date)this.actual, minute);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinSecond(int second) {
        this.dates.assertIsWithinSecond(this.info, (Date)this.actual, second);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isWithinMillisecond(int millisecond) {
        this.dates.assertIsWithinMillisecond(this.info, (Date)this.actual, millisecond);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameYearAs(Date other) {
        this.dates.assertIsInSameYearAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameYearAs(String dateAsString) {
        return this.isInSameYearAs(this.parse(dateAsString));
    }

    public S isInSameMonthAs(Date other) {
        this.dates.assertIsInSameMonthAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameMonthAs(String dateAsString) {
        return this.isInSameMonthAs(this.parse(dateAsString));
    }

    public S isInSameDayAs(Date other) {
        this.dates.assertIsInSameDayAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameDayAs(String dateAsString) {
        return this.isInSameDayAs(this.parse(dateAsString));
    }

    public S isInSameHourWindowAs(Date other) {
        this.dates.assertIsInSameHourWindowAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameHourWindowAs(String dateAsString) {
        return this.isInSameHourWindowAs(this.parse(dateAsString));
    }

    public S isInSameHourAs(Date other) {
        this.dates.assertIsInSameHourAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameHourAs(String dateAsString) {
        return this.isInSameHourAs(this.parse(dateAsString));
    }

    public S isInSameMinuteWindowAs(Date other) {
        this.dates.assertIsInSameMinuteWindowAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameMinuteWindowAs(String dateAsString) {
        return this.isInSameMinuteWindowAs(this.parse(dateAsString));
    }

    public S isInSameMinuteAs(Date other) {
        this.dates.assertIsInSameMinuteAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameMinuteAs(String dateAsString) {
        return this.isInSameMinuteAs(this.parse(dateAsString));
    }

    public S isInSameSecondWindowAs(Date other) {
        this.dates.assertIsInSameSecondWindowAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameSecondWindowAs(String dateAsString) {
        return this.isInSameSecondWindowAs(this.parse(dateAsString));
    }

    public S isInSameSecondAs(Date other) {
        this.dates.assertIsInSameSecondAs(this.info, (Date)this.actual, other);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isInSameSecondAs(String dateAsString) {
        return this.isInSameSecondAs(this.parse(dateAsString));
    }

    public S isCloseTo(Date other, long deltaInMilliseconds) {
        this.dates.assertIsCloseTo(this.info, (Date)this.actual, other, deltaInMilliseconds);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S isCloseTo(String dateAsString, long deltaInMilliseconds) {
        return this.isCloseTo(this.parse(dateAsString), deltaInMilliseconds);
    }

    public S hasTime(long timestamp) {
        this.dates.assertHasTime(this.info, (Date)this.actual, timestamp);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S hasSameTimeAs(Date date) {
        this.dates.hasSameTimeAs(this.info, (Date)this.actual, date);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S hasSameTimeAs(String dateAsString) {
        this.dates.hasSameTimeAs(this.info, (Date)this.actual, this.parse(dateAsString));
        return (S)((AbstractDateAssert)this.myself);
    }

    public S withDateFormat(DateFormat userCustomDateFormat) {
        AbstractDateAssert.registerCustomDateFormat(userCustomDateFormat);
        return (S)((AbstractDateAssert)this.myself);
    }

    public S withDateFormat(String userCustomDateFormatPattern) {
        Preconditions.checkNotNull(userCustomDateFormatPattern, DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL);
        return this.withDateFormat(new SimpleDateFormat(userCustomDateFormatPattern));
    }

    public static void setLenientDateParsing(boolean value) {
        for (DateFormat defaultDateFormat : DEFAULT_DATE_FORMATS) {
            defaultDateFormat.setLenient(value);
        }
    }

    public static void registerCustomDateFormat(DateFormat userCustomDateFormat) {
        Preconditions.checkNotNull(userCustomDateFormat, DATE_FORMAT_SHOULD_NOT_BE_NULL);
        userDateFormats.get().add(userCustomDateFormat);
    }

    public static void registerCustomDateFormat(String userCustomDateFormatPattern) {
        Preconditions.checkNotNull(userCustomDateFormatPattern, DATE_FORMAT_PATTERN_SHOULD_NOT_BE_NULL);
        AbstractDateAssert.registerCustomDateFormat(new SimpleDateFormat(userCustomDateFormatPattern));
    }

    public static void useDefaultDateFormatsOnly() {
        userDateFormats.get().clear();
    }

    public S withDefaultDateFormatsOnly() {
        AbstractDateAssert.useDefaultDateFormatsOnly();
        return (S)((AbstractDateAssert)this.myself);
    }

    @VisibleForTesting
    Date parse(String dateAsString) {
        if (dateAsString == null) {
            return null;
        }
        Date date = this.parseDateWith(dateAsString, (Collection<DateFormat>)userDateFormats.get());
        if (date != null) {
            return date;
        }
        date = this.parseDateWithDefaultDateFormats(dateAsString);
        if (date != null) {
            return date;
        }
        throw new AssertionError((Object)String.format("Failed to parse %s with any of these date formats:%n   %s", dateAsString, this.info.representation().toStringOf(this.dateFormatsInOrderOfUsage())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Date parseDateWithDefaultDateFormats(String dateAsString) {
        List<DateFormat> list = DEFAULT_DATE_FORMATS;
        synchronized (list) {
            return this.parseDateWith(dateAsString, DEFAULT_DATE_FORMATS);
        }
    }

    private List<DateFormat> dateFormatsInOrderOfUsage() {
        ArrayList<DateFormat> allDateFormatsInOrderOfUsage = Lists.newArrayList((Iterable)userDateFormats.get());
        allDateFormatsInOrderOfUsage.addAll(DEFAULT_DATE_FORMATS);
        return allDateFormatsInOrderOfUsage;
    }

    private Date parseDateWith(String dateAsString, Collection<DateFormat> dateFormats) {
        for (DateFormat defaultDateFormat : dateFormats) {
            try {
                return defaultDateFormat.parse(dateAsString);
            }
            catch (ParseException parseException) {
            }
        }
        return null;
    }

    @Override
    public S usingComparator(Comparator<? super Date> customComparator) {
        super.usingComparator(customComparator);
        this.dates = new Dates(new ComparatorBasedComparisonStrategy(customComparator));
        return (S)((AbstractDateAssert)this.myself);
    }

    @Override
    public S usingDefaultComparator() {
        super.usingDefaultComparator();
        this.dates = Dates.instance();
        return (S)((AbstractDateAssert)this.myself);
    }
}

