/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.util.Comparator;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.data.Index;
import org.assertj.core.internal.Arrays;
import org.assertj.core.internal.ComparisonStrategy;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.StandardComparisonStrategy;
import org.assertj.core.util.VisibleForTesting;

public class ShortArrays {
    private static final ShortArrays INSTANCE = new ShortArrays();
    private Arrays arrays = Arrays.instance();
    @VisibleForTesting
    Failures failures = Failures.instance();

    public static ShortArrays instance() {
        return INSTANCE;
    }

    @VisibleForTesting
    ShortArrays() {
        this(StandardComparisonStrategy.instance());
    }

    public ShortArrays(ComparisonStrategy comparisonStrategy) {
        this.arrays = new Arrays(comparisonStrategy);
    }

    @VisibleForTesting
    public Comparator<?> getComparator() {
        return this.arrays.getComparator();
    }

    public void assertNullOrEmpty(AssertionInfo info, short[] actual) {
        this.arrays.assertNullOrEmpty(info, this.failures, actual);
    }

    public void assertEmpty(AssertionInfo info, short[] actual) {
        this.arrays.assertEmpty(info, this.failures, actual);
    }

    public void assertNotEmpty(AssertionInfo info, short[] actual) {
        this.arrays.assertNotEmpty(info, this.failures, actual);
    }

    public void assertHasSize(AssertionInfo info, short[] actual, int expectedSize) {
        this.arrays.assertHasSize(info, this.failures, actual, expectedSize);
    }

    public void assertHasSameSizeAs(AssertionInfo info, short[] actual, Iterable<?> other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertHasSameSizeAs(AssertionInfo info, short[] actual, Object[] other) {
        this.arrays.assertHasSameSizeAs(info, (Object)actual, other);
    }

    public void assertContains(AssertionInfo info, short[] actual, short[] values) {
        this.arrays.assertContains(info, this.failures, actual, values);
    }

    public void assertContains(AssertionInfo info, short[] actual, short value, Index index) {
        this.arrays.assertContains(info, this.failures, actual, value, index);
    }

    public void assertDoesNotContain(AssertionInfo info, short[] actual, short value, Index index) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, value, index);
    }

    public void assertContainsOnly(AssertionInfo info, short[] actual, short[] values) {
        this.arrays.assertContainsOnly(info, this.failures, actual, values);
    }

    public void assertContainsExactly(AssertionInfo info, short[] actual, short[] values) {
        this.arrays.assertContainsExactly(info, this.failures, actual, values);
    }

    public void assertContainsOnlyOnce(AssertionInfo info, short[] actual, short[] values) {
        this.arrays.assertContainsOnlyOnce(info, this.failures, actual, values);
    }

    public void assertContainsSequence(AssertionInfo info, short[] actual, short[] sequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, sequence);
    }

    public void assertContainsSubsequence(AssertionInfo info, short[] actual, short[] subsequence) {
        this.arrays.assertContainsSequence(info, this.failures, actual, subsequence);
    }

    public void assertDoesNotContain(AssertionInfo info, short[] actual, short[] values) {
        this.arrays.assertDoesNotContain(info, this.failures, actual, values);
    }

    public void assertDoesNotHaveDuplicates(AssertionInfo info, short[] actual) {
        this.arrays.assertDoesNotHaveDuplicates(info, this.failures, actual);
    }

    public void assertStartsWith(AssertionInfo info, short[] actual, short[] sequence) {
        this.arrays.assertStartsWith(info, this.failures, actual, sequence);
    }

    public void assertEndsWith(AssertionInfo info, short[] actual, short[] sequence) {
        this.arrays.assertEndsWith(info, this.failures, actual, sequence);
    }

    public void assertIsSorted(AssertionInfo info, short[] actual) {
        this.arrays.assertIsSorted(info, this.failures, actual);
    }

    public void assertIsSortedAccordingToComparator(AssertionInfo info, short[] actual, Comparator<? super Short> comparator) {
        Arrays.assertIsSortedAccordingToComparator(info, this.failures, actual, comparator);
    }
}

