/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.groups;

import java.util.ArrayList;
import java.util.List;
import org.assertj.core.api.iterable.Extractor;
import org.assertj.core.util.Iterables;
import org.assertj.core.util.Lists;

public class FieldsOrPropertiesExtractor {
    public static <F, T> T[] extract(F[] objects, Extractor<? super F, T> extractor) {
        List<T> result = FieldsOrPropertiesExtractor.extract(Lists.newArrayList(objects), extractor);
        return Iterables.toArray(result);
    }

    public static <F, T> List<T> extract(Iterable<? extends F> objects, Extractor<? super F, T> extractor) {
        ArrayList result = Lists.newArrayList();
        for (F object : objects) {
            T newValue = extractor.extract(object);
            result.add(newValue);
        }
        return result;
    }
}

