/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.data;

import org.assertj.core.util.Objects;
import org.assertj.core.util.Strings;

public class MapEntry<K, V> {
    public final K key;
    public final V value;

    public static <K, V> MapEntry<K, V> entry(K key, V value) {
        return new MapEntry<K, V>(key, value);
    }

    private MapEntry(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MapEntry)) {
            return false;
        }
        MapEntry other = (MapEntry)obj;
        return Objects.areEqual(this.key, other.key) && Objects.areEqual(this.value, other.value);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCodeFor(this.key);
        result = 31 * result + Objects.hashCodeFor(this.value);
        return result;
    }

    public String toString() {
        return String.format("%s[key=%s, value=%s]", this.getClass().getSimpleName(), Strings.quote(this.key), Strings.quote(this.value));
    }
}

