/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.time.LocalTime;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AssertionInfo;
import org.assertj.core.error.ShouldBeAfter;
import org.assertj.core.error.ShouldBeAfterOrEqualsTo;
import org.assertj.core.error.ShouldBeBefore;
import org.assertj.core.error.ShouldBeBeforeOrEqualsTo;
import org.assertj.core.error.ShouldBeEqualIgnoringNanos;
import org.assertj.core.error.ShouldBeEqualIgnoringSeconds;
import org.assertj.core.error.ShouldHaveSameHourAs;
import org.assertj.core.internal.Failures;
import org.assertj.core.internal.Objects;

public abstract class AbstractLocalTimeAssert<S extends AbstractLocalTimeAssert<S>>
extends AbstractAssert<S, LocalTime> {
    public static final String NULL_LOCAL_TIME_PARAMETER_MESSAGE = "The LocalTime to compare actual with should not be null";

    protected AbstractLocalTimeAssert(LocalTime actual, Class<?> selfType) {
        super(actual, selfType);
    }

    protected LocalTime getActual() {
        return (LocalTime)this.actual;
    }

    public S isBefore(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!((LocalTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBefore.shouldBeBefore(this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S isBefore(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isBefore(LocalTime.parse(localTimeAsString));
    }

    public S isBeforeOrEqualTo(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (((LocalTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeBeforeOrEqualsTo.shouldBeBeforeOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S isBeforeOrEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isBeforeOrEqualTo(LocalTime.parse(localTimeAsString));
    }

    public S isAfterOrEqualTo(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (((LocalTime)this.actual).isBefore(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfterOrEqualsTo.shouldBeAfterOrEqualsTo(this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S isAfterOrEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isAfterOrEqualTo(LocalTime.parse(localTimeAsString));
    }

    public S isAfter(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!((LocalTime)this.actual).isAfter(other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeAfter.shouldBeAfter(this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S isAfter(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return this.isAfter(LocalTime.parse(localTimeAsString));
    }

    public S isEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return (S)((AbstractLocalTimeAssert)this.isEqualTo(LocalTime.parse(localTimeAsString)));
    }

    public S isNotEqualTo(String localTimeAsString) {
        AbstractLocalTimeAssert.assertLocalTimeAsStringParameterIsNotNull(localTimeAsString);
        return (S)((AbstractLocalTimeAssert)this.isNotEqualTo(LocalTime.parse(localTimeAsString)));
    }

    public S isIn(String ... localTimesAsString) {
        this.checkIsNotNullAndNotEmpty(localTimesAsString);
        return (S)((AbstractLocalTimeAssert)this.isIn(AbstractLocalTimeAssert.convertToLocalTimeArray(localTimesAsString)));
    }

    public S isNotIn(String ... localTimesAsString) {
        this.checkIsNotNullAndNotEmpty(localTimesAsString);
        return (S)((AbstractLocalTimeAssert)this.isNotIn(AbstractLocalTimeAssert.convertToLocalTimeArray(localTimesAsString)));
    }

    private static Object[] convertToLocalTimeArray(String ... localTimesAsString) {
        Object[] dates = new LocalTime[localTimesAsString.length];
        for (int i = 0; i < localTimesAsString.length; ++i) {
            dates[i] = LocalTime.parse(localTimesAsString[i]);
        }
        return dates;
    }

    private void checkIsNotNullAndNotEmpty(Object[] values) {
        if (values == null) {
            throw new IllegalArgumentException("The given LocalTime array should not be null");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException("The given LocalTime array should not be empty");
        }
    }

    private static void assertLocalTimeAsStringParameterIsNotNull(String localTimeAsString) {
        if (localTimeAsString == null) {
            throw new IllegalArgumentException("The String representing the LocalTime to compare actual with should not be null");
        }
    }

    private static void assertLocalTimeParameterIsNotNull(LocalTime other) {
        if (other == null) {
            throw new IllegalArgumentException(NULL_LOCAL_TIME_PARAMETER_MESSAGE);
        }
    }

    public S isEqualToIgnoringNanos(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.areEqualIgnoringNanos((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringNanos.shouldBeEqualIgnoringNanos((LocalTime)this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S isEqualToIgnoringSeconds(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.areEqualIgnoringSeconds((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldBeEqualIgnoringSeconds.shouldBeEqualIgnoringSeconds((LocalTime)this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    public S hasSameHourAs(LocalTime other) {
        Objects.instance().assertNotNull(this.info, this.actual);
        AbstractLocalTimeAssert.assertLocalTimeParameterIsNotNull(other);
        if (!AbstractLocalTimeAssert.haveSameHourField((LocalTime)this.actual, other)) {
            throw Failures.instance().failure((AssertionInfo)this.info, ShouldHaveSameHourAs.shouldHaveSameHourAs((LocalTime)this.actual, other));
        }
        return (S)((AbstractLocalTimeAssert)this.myself);
    }

    private static boolean areEqualIgnoringNanos(LocalTime actual, LocalTime other) {
        return AbstractLocalTimeAssert.areEqualIgnoringSeconds(actual, other) && actual.getSecond() == other.getSecond();
    }

    private static boolean areEqualIgnoringSeconds(LocalTime actual, LocalTime other) {
        return AbstractLocalTimeAssert.haveSameHourField(actual, other) && actual.getMinute() == other.getMinute();
    }

    private static boolean haveSameHourField(LocalTime actual, LocalTime other) {
        return actual.getHour() == other.getHour();
    }
}

